/**** 
 NAME
	inline-test.c - test program to check the compiler supports
			"inline" functions
 VERSION
	$Id$
 CHANGELOG
	$Log$
 */

#include <stdio.h>

typedef	struct {
	float x ;
	float y ;
	float z ;
} vector3d_t ;

inline void set(vector3d_t * dst, float x, float y, float z)
{
	dst->x = x ; dst->y = y ; dst->z = z ; 
}

inline void init(vector3d_t * dst)
{
	set(dst, 0.0, 0.0, 0.0) ;
}

inline void print(vector3d_t const * src)
{
	printf("x=%f, y=%f, z=%f\n", src->x, src->y, src->z) ;
}

int main()
{
	vector3d_t	vec ;
	printf("*** inline-test\n") ;
	init(&vec) ;
	print(&vec) ;
	printf("bye.\n") ;
	return 0 ;
}

