/*****
 NAME
 	fvector-test.c - test program for vector2d or vector3d operation
 VERSION
 	$Id$
 CHANGELOG
 	$Log$
 */

#include <coconut/fvector.h>
#include <coconut/dvector.h>
#include <stdio.h>
#include <stdlib.h>

int main()
{
	double		d ;
	vector2d_t	v2d_1, v2d_2, v2d_3 ;
	vector3d_t	v3d_1, v3d_2, v3d_3 ;

	printf("*** test program for vector2d or vector3d functions\n");

	/* v2d_set */
	printf("--- v2d_set\n") ;
	v2d_set(v2d_1, 0.0, 0.0) ;
	printf("  v2d_set(v2d_1, 0.0, 0.0) = ");
	  fprintv2d(stdout, &v2d_1);
	printf("\n") ;

	/* v3d_set */
	printf("--- v3d_set\n") ;
	v3d_set(v3d_1, 0.1, 0.2, 0.3) ;
	printf("  v2d_set(v2d_1, 0.1, 0.2, 0.3) = "); 
	  fprintv3d(stdout, &v3d_1);
	printf("\n") ;

	/* v2d_reverse */
	printf("--- v2d_reverse\n") ;
	v2d_reverse(v2d_1) ;
	printf("  reverse => "); fprintv2d(stdout, &v2d_1) ; printf("\n") ;

	/* v3d_reverse */
	printf("--- v3d_reverse\n") ;
	v3d_reverse(v3d_1) ;
	printf("  reverse => "); fprintv3d(stdout, &v3d_1) ; printf("\n") ;

	/* v2d_scalar_pos_tolerance */
	printf("--- v2d_scalar_pos_tolerance:\n") ;
	d = 0.01 ;
	printf("  v2d_scalar_pos_tolerance(%.3f) => %.3f\n", d, 
	  v2d_scalar_pos_tolerance(d)) ;
	d = v2d_tolerance / 2 ;
	printf("  v2d_scalar_pos_tolerance(%.3f) => %.3f\n", d, 
	  v2d_scalar_pos_tolerance(d)) ;

	/* v3d_scalar_pos_tolerance */
	printf("--- v3d_scalar_pos_tolerance:\n") ;
	d = 0.01 ;
	printf("  v3d_scalar_pos_tolerance(%.3f) => %.3f\n", d, 
	  v3d_scalar_pos_tolerance(d)) ;
	d = v3d_tolerance / 2 ;
	printf("  v3d_scalar_pos_tolerance(%.3f) => %.3f\n", d, 
	  v3d_scalar_pos_tolerance(d)) ;

	/* v2d_scalar_round */
	printf("--- v2d_scalar_round:\n") ;
	d = 0.01 ;
	printf("  v2d_scalar_round(%.3f) => %.3f\n", d, v2d_scalar_round(d)) ;
	d = v2d_tolerance / 2 ;
	printf("  v2d_scalar_round(%.3f) => %.3f\n", d, v2d_scalar_round(d)) ;

	/* v3d_scalar_round */
	printf("--- v3d_scalar_round:\n") ;
	d = 0.01 ;
	printf("  v3d_scalar_round(%.3f) => %.3f\n", d, v3d_scalar_round(d)) ;
	d = v3d_tolerance / 2 ;
	printf("  v3d_scalar_round(%.3f) => %.3f\n", d, v3d_scalar_round(d)) ;

	/* v2d_scalar_no_neg_zero */
	printf("--- v2d_scalar_no_neg_zero:\n") ;
	d = 0.01 ;
	printf("  v2d_scalar_no_neg_zero(XXX) => %.3f\n", 
	  v2d_scalar_no_neg_zero(d)) ;
	d = -0.0 ;
	printf("  v2d_scalar_no_neg_zero(XXX) => %.3f\n", 
	  v2d_scalar_no_neg_zero(d)) ;

	/* v3d_scalar_no_neg_zero */
	printf("--- v3d_scalar_no_neg_zero:\n") ;
	d = 0.01 ;
	printf("  v3d_scalar_no_neg_zero(XXX) => %.3f\n", 
	  v3d_scalar_no_neg_zero(d)) ;
	d = -0.0 ;
	printf("  v3d_scalar_no_neg_zero(XXX) => %.3f\n", 
	  v3d_scalar_no_neg_zero(d)) ;

	/* v2d_magnitude */
	printf("--- v2d_magnitude:\n") ;
	v2d_set(v2d_1, 1.0, 2.0) ;
	printf("  magnitude of (1.0, 2.0) => %.3f\n", v2d_magnitude(v2d_1)) ;

	/* v3d_magnitude */
	printf("--- v3d_magnitude:\n") ;
	v3d_set(v3d_1, 1.0, 2.0, 3.0) ;
	printf("  magnitude of (1.0, 2.0, 3.0) => %.3f\n", v3d_magnitude(v3d_1));

	/* v2d_normalize */
	printf("--- v2d_normalize:\n") ;
	v2d_set(v2d_1, 10.0, 30.0) ;
	v2d_normalize(v2d_1) ;
	printf("  normalize (10.0, 30.0) => ") ;
	  fprintv2d(stdout, &v2d_1) ; printf("\n") ;
	v2d_normalize_z(v2d_1) ;
	printf("  normalize (10.0, 30.0) => ") ;
	  fprintv2d(stdout, &v2d_1) ; printf("\n") ;

	/* v3d_normalize */
	printf("--- v3d_normalize:\n") ;
	v3d_set(v3d_1, 10.0, 30.0, 20.0) ;
	v3d_normalize(v3d_1) ;
	printf("  normalize (10.0, 30.0, 20.0) => ") ;
	  fprintv3d(stdout, &v3d_1) ; printf("\n") ;
	v3d_normalize_z(v3d_1) ;
	printf("  normalize (10.0, 30.0, 20.0) => ") ;
	  fprintv3d(stdout, &v3d_1) ; printf("\n") ;

	/* v2d_uni_add */
	printf("--- v2d_uni_add\n") ;
	v2d_set(v2d_1, 1.0, 2.0) ; v2d_set(v2d_2, 4.0, 5.0) ;
	printf("  ") ; fprintv2d(stdout, &v2d_1) ; printf(" + ") ;
	fprintv2d(stdout, &v2d_2) ; printf(" = ") ;
	v2d_uni_add(v2d_1, v2d_2) ;
	fprintv2d(stdout, &v2d_1) ; printf("\n") ;

	/* v3d_uni_add */
	printf("--- v3d_uni_add\n") ;
	v3d_set(v3d_1, 1.0, 2.0, 3.0) ; v3d_set(v3d_2, 4.0, 5.0, 6.0) ;
	printf("  ") ; fprintv3d(stdout, &v3d_1) ; printf(" + ") ;
	fprintv3d(stdout, &v3d_2) ; printf(" = ") ;
	v3d_uni_add(v3d_1, v3d_2) ;
	fprintv3d(stdout, &v3d_1) ; printf("\n") ;

	/* v2d_uni_sub */
	printf("--- v2d_uni_sub\n") ;
	v2d_set(v2d_1, 1.0, 2.0) ; v2d_set(v2d_2, 4.0, 5.0) ;
	printf("  ") ; fprintv2d(stdout, &v2d_1) ; printf(" - ") ;
	fprintv2d(stdout, &v2d_2) ; printf(" = ") ;
	v2d_uni_sub(v2d_1, v2d_2) ;
	fprintv2d(stdout, &v2d_1) ; printf("\n") ;

	/* v3d_uni_sub */
	printf("--- v3d_uni_sub\n") ;
	v3d_set(v3d_1, 1.0, 2.0, 3.0) ; v3d_set(v3d_2, 4.0, 5.0, 6.0) ;
	printf("  ") ; fprintv3d(stdout, &v3d_1) ; printf(" - ") ;
	fprintv3d(stdout, &v3d_2) ; printf(" = ") ;
	v3d_uni_sub(v3d_1, v3d_2) ;
	fprintv3d(stdout, &v3d_1) ; printf("\n") ;

	/* v2d_scalar_mult */
	printf("--- v2d_scalar_mult\n") ;
	v2d_set(v2d_1, 1.0, 2.0) ; 
	printf("  ") ; fprintv2d(stdout, &v2d_1) ; printf(" * 10.0 = ") ;
	v2d_scalar_mult(v2d_1, 10.0) ; 
	fprintv2d(stdout, &v2d_1) ; printf("\n") ;

	/* v3d_scalar_mult */
	printf("--- v3d_scalar_mult\n") ;
	v3d_set(v3d_1, 1.0, 2.0, 3.0) ; 
	printf("  ") ; fprintv3d(stdout, &v3d_1) ; printf(" * 10.0 = ") ;
	v3d_scalar_mult(v3d_1, 10.0) ; 
	fprintv3d(stdout, &v3d_1) ; printf("\n") ;

	/* v2d_scalar_div */
	printf("--- v2d_scalar_div\n") ;
	v2d_set(v2d_1, 1.0, 2.0) ; 
	printf("  ") ; fprintv2d(stdout, &v2d_1) ; printf(" / 10.0 = ") ;
	v2d_scalar_div(v2d_1, 10.0) ; 
	fprintv2d(stdout, &v2d_1) ; printf("\n") ;

	/* v3d_scalar_div */
	printf("--- v3d_scalar_div\n") ;
	v3d_set(v3d_1, 1.0, 2.0, 3.0) ; 
	printf("  ") ; fprintv3d(stdout, &v3d_1) ; printf(" / 10.0 = ") ;
	v3d_scalar_div(v3d_1, 10.0) ; 
	fprintv3d(stdout, &v3d_1) ; printf("\n") ;

	/* v2d_bin_add */
	printf("--- v2d_bin_add\n") ;
	v2d_set(v2d_1, 10.0, 11.0) ;
	v2d_set(v2d_2, -10.0, -11.0) ;
	printf("  ") ; fprintv2d(stdout, &v2d_1) ; printf(" + ") ;
	fprintv2d(stdout, &v2d_2); printf(" = ") ;
	v2d_bin_add(v2d_3, v2d_1, v2d_2) ;
	fprintv2d(stdout, &v2d_3) ; printf("\n") ;

	/* v3d_bin_add */
	printf("--- v3d_bin_add\n") ;
	v3d_set(v3d_1, 10.0, 11.0, 12.0) ;
	v3d_set(v3d_2, -10.0, -11.0, -12.0) ;
	printf("  ") ; fprintv3d(stdout, &v3d_1) ; printf(" + ") ;
	fprintv3d(stdout, &v3d_2); printf(" = ") ;
	v3d_bin_add(v3d_3, v3d_1, v3d_2) ;
	fprintv3d(stdout, &v3d_3) ; printf("\n") ;

	/* v2d_bin_sub */
	printf("--- v2d_bin_sub\n") ;
	v2d_set(v2d_1, 10.0, 11.0) ;
	v2d_set(v2d_2, -10.0, -11.0) ;
	printf("  ") ; fprintv2d(stdout, &v2d_1) ; printf(" - ") ;
	fprintv2d(stdout, &v2d_2); printf(" = ") ;
	v2d_bin_sub(v2d_3, v2d_1, v2d_2) ;
	fprintv2d(stdout, &v2d_3) ; printf("\n") ;

	/* v3d_bin_sub */
	printf("--- v3d_bin_sub\n") ;
	v3d_set(v3d_1, 10.0, 11.0, 12.0) ;
	v3d_set(v3d_2, -10.0, -11.0, -12.0) ;
	printf("  ") ; fprintv3d(stdout, &v3d_1) ; printf(" - ") ;
	fprintv3d(stdout, &v3d_2); printf(" = ") ;
	v3d_bin_sub(v3d_3, v3d_1, v3d_2) ;
	fprintv3d(stdout, &v3d_3) ; printf("\n") ;

	exit(0) ;
}

