/*****
 NAME
 	cxmltree-test4.m - test program for CXMLTree class (No.4)
 VERSION
 	$Id$
 CHANGELOG
 	$Log$
 */

#include <coconut/cxmltree.h>
#include <coconut/cfile.h>
#include <coconut/cerror.h>

void check_error(const char * msg, id <PError> err)
{
	printf("trying to %s ... ", msg) ;
	if(err == nil){
		printf("OK\n") ;
	} else {
		printf("ERROR (code %d)\n", [err code]) ;
		exit(1) ;
	}
}

void check_node(const char * msg, id <PXMLNode> node)
{
	printf("trying to %s ... %s\n", msg, node ? "TRUE" : "FALSE") ;
}

int main()
{
	id <PXMLTree>	tree1 ;
	id <PXMLTree>	tree2 ;
	id <PXMLNode>		node1 ;
	static const char	inname[] = "cxmltree-test4.xml" ;

	printf("**** test program for CXMLTree class (4)\n");

	printf("initialize:\n") ;
	tree1 = [[CXMLTree alloc] init] ;
	tree2 = [[CXMLTree alloc] init] ;

	printf("loading %s\n", inname) ;
	check_error("load(1)", [tree1 loadFile: inname validate: FALSE]==0 ? 
	  nil : [CError can_not_read]) ;

	printf("new document\n") ;
	[tree2 newDocument: NULL] ;
	[tree2 addNextNode: "root" content: "root context"] ;

	printf("initial state\ntree1:\n") ;
	[tree1 saveStream: nil];
	printf("tree2:\n");
	[tree2 saveStream: nil];

	printf("choose source node\n");
	check_node("hasChildren", [[tree1 currentNode] child]) ;
	check_node("skipToChild", [tree1 skipToChild]) ;
	printf("tag name: %s\n", [[tree1 currentNode] tagName]) ;

	printf("copy node from 1 to 2\n") ;
	[[tree2 currentNode] appendChild: 
	  [[tree1 currentNode] duplicate]] ;

	printf("print copieed state\ntree1:\n") ;
	[tree1 saveStream: nil];
	printf("tree2:\n");
	[tree2 saveStream: nil];

	printf("move node from 1 to 2\n") ;
	check_node("skipNext", [tree1 skipNext]) ;
	printf("tag name: %s\n", [[tree1 currentNode] tagName]) ;

	printf("move node from 1 to 2\n") ;
	node1 = [tree1 currentNode] ;
	[node1 unlink] ;
	[[tree2 currentNode] appendChild: node1] ;

	printf("print moved state\ntree1:\n") ;
	[tree1 saveStream: nil];
	printf("tree2:\n");
	[tree2 saveStream: nil];

	[tree1 release] ;
	[tree2 release] ;
	printf("bye.\n");
	return 0 ;
}

