/*
 NAME
	cxmltree-test3.m - test program for CXMLTree class
 VERSION
	$Id$
 CHANGELOG
	$Log$
 */

#include <coconut/cxmltree.h>
#include <coconut/cxmlfactory.h>
#include <coconut/cfile.h>
#include <coconut/cindtstream.h>
#include <coconut/cregexp.h>
#include <coconut/fbasic.h>
#include <stdio.h>
#include <stdlib.h>

CIndtStream *	indentout ;

void check_error(const char * msg, id <PError> err)
{
	[indentout putFormat: "%s ... %s\n", msg, err == nil ? "OK" : "ERROR"] ;
	if(err != nil)
		exit(1) ;
}

int main(){
	CXMLTree *	tree ;
	CFile *		output ;
	CRegExp *	tagname ;
	CRegExp *	attrname ;
	CRegExp *	attrvalue ;
	const char 	inputname[] = "./cxmltree-test3.xml" ;
	int		lineno ;
	id <PError>	err ;

	/* printf("*** test program for CXMLTree class (3)\n") ; */

	/* open output file */
	output = [[CFile alloc] init] ;
	err =  [output open: write_open name: NULL] ;
	g_assert(err == nil) ;
	indentout = [[CIndtStream alloc] initIndtStream: output] ;
	g_assert(indentout != nil) ;

	[indentout putPtr: "*** test program for CXMLTree class (3)\n"] ;

	/* allocate xmlparser and link with input/output stream */
	tree = [[CXMLTree alloc] init] ;

	/* load into memory */
	if((lineno = [tree loadFile: inputname validate: FALSE]) != 0){
		fprintf(stderr, "this file containes some errors at line %d.\n",
		  lineno); 
		exit(1) ;
	}

	/* print to standard output */
	err = [tree saveStream: output] ;
	[indentout putFormat: "save result ... %d\n", [err code]] ;
	[[tree rootNode] foreachObject: @selector(print:) with: indentout 
	  with: NULL] ;

	/* choose by tag name */
	[indentout putFormat: "=== choose by tag name\n"] ;
	tagname = [[CRegExp alloc] init] ;
	err = [tagname compile: "local"] ;
	[indentout putFormat: "compile result for tag name : %d\n", [err code]];

	[[tree rootNode] foreachObject: @selector(chooseTagNameByRegExp:)
	  with: tagname with: nil] ;
	[[tree rootNode] foreachConditionObject: &isAcceptedSelection
	  message: @selector(print:) with: indentout with: nil] ;

	/* choose by attr name */
	[indentout putPtr: "=== choose by attr name\n"] ;
	attrname = [[CRegExp alloc] init] ;
	err = [attrname compile: "permission"] ;
	[indentout putFormat: "compile result for attr name : %d\n", 
	  [err code]] ;

	[[tree rootNode] foreachConditionObject: &isNotRejectedSelection
	  message: @selector(chooseAttrNameByRegExp:) with: attrname with: nil];
	[[tree rootNode] foreachConditionObject: &isAcceptedSelection
	  message: @selector(print:) with: indentout with: nil] ;

	/* remove by attr name and value */
	[indentout putPtr: "=== remove by attr name and value\n"] ;
	attrvalue = [[CRegExp alloc] init] ;
	err = [attrvalue compile: "."] ;
	[indentout putFormat: "compile result for attr value : %d\n", 
	  [err code]] ;
	[[tree rootNode] foreachConditionObject: &isNotRejectedSelection
	  message: @selector(chooseAttrNameByRegExp:) with: attrname with: nil];
	[[tree rootNode] foreachConditionObject: &isAcceptedSelection
	  message: @selector(removeAttrByRegExp:value:) with: attrname 
	  with: attrvalue] ;
	[[tree rootNode] foreachConditionObject: &isAcceptedSelection
	  message: @selector(print:) with: indentout with: nil] ;

	/* remove spaces */
	[indentout putPtr: "=== remove side spaces\n"] ;
	[CXMLFactory removeEmptyTextChildren: [tree rootNode]] ;
	[[tree rootNode] foreachObject: @selector(print:) with: indentout 
	  with: nil] ;

	[indentout putPtr: "closing files ... "] ;
	[output flush] ;
	[output close] ;

	printf("done.\nreleasing objects ... ") ;
	[tree release] ;
	[indentout release] ;
	[output release] ;
	[tagname release] ;
	[attrname release] ;
	printf("done.\n") ;

	printf("bye.\n") ;
	return 0 ;
}

