/*****
 NAME
	cxmltree-test2.m
 VERSION
	$Id$
 CHANGELOG
	$Log$
 */

#include <coconut/cxmltree.h>
#include <coconut/cxmlfactory.h>
#include <coconut/cstring.h>
#include <coconut/cfile.h>
#include <coconut/cindtstream.h>
#include <stdlib.h>
#include <stdio.h>

@interface CTest : CObject
{
}
- foreachPrintText: (void *) p1 with: (void *) p2 ;
@end

@implementation CTest
- foreachPrintText: (void *) p1 with: (void *) p2 
{	
	id <PXMLNode>	node = (id <PXMLNode>) p1 ;
	id <PConstStr>	content ;
	id <PString>	string ;

	if([node isTextNode]){
		content = [node content] ;
		string = [CString newString: [content ptr] length:
		  [content length]] ;
		[string removeSideSpaces] ;
		printf("text node: \"%s\"\n", [string ptr]) ;
		[string release] ;
		[content release] ;
	} else {
		printf("NOT text node:\n") ;
	}
	return nil ;
}

@end

void check_error(const char * msg, id <PError> err)
{
	printf("%s ... %s\n", msg, err == nil ? "OK" : "ERROR") ;
	if(err != nil)
		exit(1) ;
}

int main()
{
	id <PError>		err ;
	CXMLTree *		tree ;
	CFile *			output_file ;
	CIndtStream *		output_stream ;
	CTest *			test ;
	id <PXMLNode>		node ;
	char 			input_name[] = "./cxmltree-test2.xml" ;
	const utf8_char *	topname ;
	const utf8_char		none[] ="none" ;

	/* generate parser */
	test = [[CTest alloc] init] ;

	/* open output file */
	output_file = [[CFile alloc] init] ;
	err = [output_file open: write_open name: NULL] ;
	g_assert(err == nil) ;

	output_stream = [[CIndtStream alloc] initIndtStream: output_file] ;
	g_assert(output_stream != nil) ;

	[output_stream putPtr: "*** test program for CXMLTree class Part II\n"];

	/* connect input and output to parser */
	tree = [[CXMLTree alloc] init] ;
	[CXMLFactory setErrorHandler: output_file] ;
	if([tree loadFile: input_name validate: FALSE] != 0){
		[output_stream putPtr: "this file is not valid text.\n"] ;
		[output_stream flush] ;
		exit(1) ;
	}
	[output_stream putFormat: "the file \"%s\" is valid text.\n", 
	  [[tree inputFileName] ptr]] ;

	topname = [[tree rootNode] tagName] ;
	topname = topname ? topname : none ;
	[output_stream putFormat: "the name of top tag is %s\n", topname] ;

	node = [CXMLFactory searchNodeByName: "local" from: [tree rootNode]
	  depth: -1 follower: TRUE] ;
	[output_stream putFormat: "search <local> tag ... %s\n", 
	  node ? "found" : "not found"] ;
	if(node){
		[node print: output_stream] ;
		[output_stream flush] ;
	} else {
		[output_stream putPtr: "ERROR: the node is not found\n"] ;
		[output_stream flush] ;
		exit(1) ;
	}

	/* search test */
	[output_stream putPtr: "search node by it's name (1):\n"] ;
	[tree moveToRoot] ;
	if((node = [CXMLFactory searchNodeByName: "usr" from: [tree rootNode]
	  depth: 2 follower: FALSE]) != nil){
		[node print: output_stream] ;
		[output_stream flush] ;
	} else
		[output_stream putPtr: "\"usr\" node is not found\n"] ;
	[output_stream putPtr: "search node by it's name (2):\n"] ;
	if((node = [CXMLFactory searchNodeByName: "local" from: [tree rootNode]
	  depth: 2 follower: FALSE]) != nil){
		[node print: output_stream] ;
		[output_stream flush] ;
	} else
		[output_stream putPtr: "OK: \"local\" node is not found\n"] ;
	[output_stream putPtr: "search node by it's name (3):\n"] ;
	[tree skipToChild] ;
	if((node = [CXMLFactory searchNodeByName: "local" from: [tree rootNode]
	  depth: 3 follower: FALSE]) != nil){
		[node print: output_stream] ;
		[output_stream flush] ;
	} else
		[output_stream putPtr: "ERROR: \"local\" node is not found\n"];

	/* print text test */
	[output_stream putPtr: "print test nodes:\n"] ;
	[output_stream flush] ;
	[[tree rootNode] foreach: test message: 
	  @selector(foreachPrintText:with:) with: NULL] ;

	[tree release] ;
	[output_stream release] ;
	[output_file release] ;
	
	printf("bye\n") ;
	exit(0) ;
}

