/*****
 NAME
 	cxmltable-test.m - test program for CXMLTable class
 VERSION
 	$Id$
 CHANGELOG
 	$Log$
 */

#include <coconut/cxmltable.h>
#include <coconut/cxmltree.h>
#include <coconut/cfile.h>

void init_document(id <PXMLTree> tree)
{	
	[tree appendChildNode: "root" content: NULL] ;
	  [tree moveToChild] ; [tree moveToTail] ;
	    [tree appendChildNode: "child1" content: "child1-data"] ;
	    [tree moveToChild] ; [tree moveToTail] ;
	      [tree addNextNode:     "child2" content: "child2-data"] ;
	    [tree moveToParent] ;
	  [tree moveToParent] ;
	[tree appendNewline] ;
}

void check_error(const char * msg, id <PError> err)
{
	printf("checking %s ... ", msg) ;
	if(err == nil){
		printf("OK\n") ;
	} else {
		printf("NG\n[ERROR] err %d \n", [err code]) ;
		exit(1) ;
	}
}

int main()
{
	CXMLTable *	table ;
	CFile *		io ;
	id <PError>	err ;
	id <PXMLTree> 	tree1 ;
	id <PXMLTree> 	tree2 ;
	id <PBasicStr>	name ;
	const char *	ptr ;

	printf("***** test program for CXMLTable class\n") ;

	io = [[CFile alloc] init] ;
	err = [io open: write_open name: NULL] ;
	g_assert(err == nil) ;

	table = [[CXMLTable alloc] initXMLTable: io] ;

	tree1 = [table newXmlDocument: NULL] ;
	tree2 = [table newXmlDocument: "./cxmltable-test.xml"] ;

	/* generate content of tree1 */
	printf("- initialzie documents\n") ;
	printf("-- tree 1\n") ;
	init_document(tree1) ;
	check_error("save 1", [tree1 saveFile]) ;
	[io flush] ;

	printf("-- tree 2\n") ;
	init_document(tree2) ;
	check_error("save2", [tree2 saveStream: io]) ;
	[io flush] ;
	[io close] ;
	[io release] ;

	/* search the file name */
	name = [table searchOutputFileNameByNode: [tree2 rootNode]] ;
	ptr = [name ptr] ;
	printf("search tree2 -> \"%s\"\n", ptr ? ptr : "<null>") ;

	/* all objects (tree*, output*) will be released */
	[table release] ;
	printf("bye.\n") ;
	exit(0) ;
}

