/*****
 NAME
 	cxmlfactory-test.m - test program for CXMLFactory methods
 VERSION
 	$Id$
 CHANGELOG
 	$Log$
 */

#include <coconut/cxmlfactory.h>
#include <coconut/cxmltree.h>

int main()
{
	const char	inname[] = "cxmlfactory-test2.xml" ;
	id <PXMLTree>	tree ;
	u_int		lineno ;

	printf("*** test program for CXMLFactory2\n");
	tree = [[CXMLTree alloc] init] ;
	lineno = [tree loadFile: inname validate: FALSE] ;
	if(lineno != 0){
		printf("ERROR: load failed\n");
		exit(1) ;
	}

	/* remove the heading spaces */
	[CXMLFactory removeFirstEmptyTextChildren: [tree rootNode]] ;
	[tree saveStream: nil] ;

	/* remove the tail spaces */
	[CXMLFactory removeLastEmptyTextChildren: [tree rootNode]] ;
	[tree saveStream: nil] ;

	/* release the data */
	[tree release] ;
	printf("bye.\n") ;
	return 0 ;
}

