/*****
 NAME
 	cxmlfactory-test.m - test program for CXMLFactory methods
 VERSION
 	$Id$
 CHANGELOG
 	$Log$
 */

#include <coconut/cxmlfactory.h>
#include <coconut/cxmltree.h>

int main()
{
	const char	inname[] = "cxmlfactory-test.xml" ;
	id <PXMLTree>	tree ;
	u_int		lineno ;

	printf("*** test program for CXMLFactory\n");
	tree = [[CXMLTree alloc] init] ;
	lineno = [tree loadFile: inname validate: FALSE] ;
	if(lineno != 0){
		printf("ERROR: load failed\n");
		exit(1) ;
	}

	/* pretty the data */
	[CXMLFactory pretty: [tree rootNode] indent: "-"] ;

	/* output the result */
	[tree saveStream: nil] ;

	/* release the data */
	[tree release] ;
	printf("bye.\n") ;
	return 0 ;
}

