/*****
 NAME
 	cxmlalloc.m - test program for memory allocator for XML
 VERSION
 	$Id$
 CHANGELOG
 	$Log$
 */

#include <coconut/cxmlalloc.h>
#include <stdlib.h>

int main()
{
	id <PAllocator>	allocator ;
	char *	ptr ;
	char *	p ;
	char	c ;
	int	i ;

	printf("*** test program for CXMLAlloc class\n") ;
	allocator = [[CXMLAlloc alloc] init] ;
	
	printf("allocate:\n");
	ptr = [allocator allocate: 27] ;
	for(c='a', p=ptr ; c<='z' ; c++, p++)
		*p = c ;
	*p = '\0' ;
	printf("str: \"%s\"\n", ptr) ;

	printf("reallocate:\n");
	ptr = [allocator reallocate: ptr size: 53] ;
	for(c='A', p=&ptr[26] ; c<='Z' ; c++, p++)
		*p = c ;
	*p = '\0' ;
	printf("str: \"%s\"\n", ptr) ;

	printf("overwriting:\n") ;
	for(i=0, p=ptr ; i<53 ; i++,p++)
		*p='!' ;
	[allocator free: ptr] ;

	printf("reallocate2:\n");
	ptr = [allocator reallocate: NULL size: 27] ;
	for(c='A', p=ptr ; c<='Z' ; c++, p++)
		*p = c ;
	*p = '\0' ;
	printf("str: \"%s\"\n", ptr) ;

	printf("free:\n") ;
	[allocator free: NULL] ;
	[allocator free: ptr] ;

	[allocator release] ;
	printf("bye.\n") ;
	exit(0);
}

