/*****
 NAME
 	cwordlist-test.m - test program for CWordList
 VERSION
 	$Id$
 CHANGELOG
 	$Log$
 */

#include <coconut/cwordlist.h>

void print_list(char * msg, id <PWordList> list)
{
	id <PString>	str ;
	u_int		i ;

	printf("%s:\n", msg) ;
	for(i=0 ; (str = [list item: i]) != nil ; i++){
		printf("[%d] \"%s\"\n", i, [str ptr]) ;
	}
}

int main()
{
	id <PWordList>	list1 ;
	id <PWordList>	list2 ;
	const utf8_char	msg1[] = " abcde fgh " ;
	const utf8_char	msg2[] = "----a---" ;
	const utf8_char	msg3[] = " 	" ;

	printf("*** test program for CWordList class\n") ;

	printf("initial state1:\n") ;
	list1 = [[CWordList alloc] initWordList: msg1 length: strlen(msg1)
	  keepSpaces: TRUE] ;
	list2 = [[CWordList alloc] initWordList: msg1 length: strlen(msg1)
	  keepSpaces: FALSE] ;
	print_list("list1", list1) ;
	print_list("list2", list2) ;

	printf("alnum only:\n") ;
	[list1 setPtr: msg2 length: strlen(msg2) keepSpaces: TRUE] ;
	[list2 setPtr: msg2 length: strlen(msg2) keepSpaces: FALSE] ;
	print_list("list1", list1) ;
	print_list("list2", list2) ;

	printf("space only:\n") ;
	[list1 setPtr: msg3 length: strlen(msg3) keepSpaces: TRUE] ;
	[list2 setPtr: msg3 length: strlen(msg3) keepSpaces: FALSE] ;
	print_list("list1", list1) ;
	print_list("list2", list2) ;

	printf("bye\n");
	return 0 ;
}

