/*****
 NAME
 	ctoken-test.m - test program for CToken class
 VERSION
 	$Id$
 CHANGELOG
 	$Log$
 */

#include <coconut/ctoken.h>
#include <coconut/cindtstream.h>
#include <coconut/cconststr.h>
#include <coconut/creal.h>
#include <stdlib.h>

int main()
{
	id <PToken>		token ;
	id <PIndentStream>	output ;
	id <PNumber>		num ;
	id <PConstStr>		str ;

	output = [[CIndtStream alloc] init] ;
	[output putPtr: "*** test program for CToken class \n"] ;

	token = [CToken newToken] ;
	num = [CReal newReal: 3.14] ;
	str = [CConstStr newConstStr: "Hello, World"] ;

	[output putPtr: "initial state:\n"] ;
	[token print: output] ;
	[output putChar: '\n'] ;

	[output putPtr: "error token:\n"] ;
	[token setErrorCode: can_not_happen_err] ;
	[token print: output] ;
	[output putChar: '\n'] ;

	[output putPtr: "number token:\n"] ;
	[token setNumber: num] ;
	[token print: output] ;
	[output putFormat: "\nretain count %d\n", [token retainCount]] ;
	[num release] ;

	[output putPtr: "string token:\n"] ;
	[token setString: str] ;
	[token print: output] ;
	[output putFormat: "\nretain count %d\n", [token retainCount]] ;
	[str release] ;

	[output putPtr: "ident token:\n"] ;
	[token setIdent: str] ;
	[token print: output] ;
	[output putFormat: "\nretain count %d\n", [token retainCount]] ;
	[str release] ;

	[output putPtr: "rword token:\n"] ;
	[token setRWord: 100 str: str] ;
	[token print: output] ;
	[output putFormat: "\nretain count %d\n", [token retainCount]] ;
	[str release] ;

	[output putPtr: "closing output:\n"] ;
	[output putFormat: "num : %f\n", [num realNum]] ;
	[output putFormat: "str : %s\n", [str ptr]] ;
	[num release] ;
	[str release] ;
	[token release] ;
	[output flush] ;
	[output release] ;

	printf("bye\n") ;
	exit(0) ;
}

