/*****
 NAME
 	ctext-test.m - test program for CText class
 VERSION
 	$Id$
 CHANGELOG
 	$Log$
 */

#include <coconut/ctext.h>
#include <coconut/cfile.h>
#include <coconut/cindtstream.h>
#include <stdlib.h>

int main()
{
	id <PError>		err ;
	id <PText>		text ;
	id <PFile>		outfile ;
	id <PString>		concat ;
	id <PIndentStream>	output ;
	const utf8_char	line1[] = "this is 1st line" ;
	const utf8_char	line2[] = "2nd\n\n4th\n and 5 line" ;
	const utf8_char	line3[] = "6th line\n" ;
	const utf8_char line4[] = "abc\ndef" ;
	const utf8_char line5[] = "\n" ;
	const utf8_char line6[] = "\nb\n" ;
	const utf8_char line7[] = "" ;
	const utf8_char line8[] = "[]" ;
	const utf8_char line9[] = "   Hello, World!\n    Good morning !!" ;

	printf("*** test program for CText class\n") ;
	text = [[CText alloc] initText: TRUE] ;
	outfile = [[CFile alloc] init] ;
	err = [outfile open: write_open name: NULL] ;
	if(err != nil){
		printf("ERROR: can not open standard output.\n"); 
		exit(1) ;
	}
	output = [[CIndtStream alloc] initIndtStream: outfile] ;

	[output putPtr: "---- initial state:\n"] ;
	[text print: output] ;
	[output putPtr: "---- end of initial state:\n"] ;
	[output flush] ;

	[output putPtr: "---- append line:\n"] ;
	[text appendPtr: line1 length: strlen(line1)] ;
	[text print: output] ;
	[output putPtr: "---- end of append line:\n"] ;
	[output flush] ;

	[output putPtr: "---- append move lines:\n"] ;
	[text appendPtr: line2 length: strlen(line2)] ;
	[text appendPtr: line3 length: strlen(line3)] ;
	[text print: output] ;
	[output putPtr: "---- end of append move lines:\n"] ;
	[output flush] ;

	[output putPtr: "---- prepend line(s) No.1 :\n"] ;
	[text prependPtr: line4 length: strlen(line4)] ;
	[text print: output] ;
	[output putPtr: "---- end of prepend line(s) No.1 :\n"] ;
	[output flush] ;

	[output putPtr: "---- prepend line(s) No.2 :\n"] ;
	[text prependPtr: line5 length: strlen(line5)] ;
	[text print: output] ;
	[output putPtr: "---- end of prepend line(s) No.2 :\n"] ;
	[output flush] ;

	[output putPtr: "---- prepend line(s) No.3 :\n"] ;
	[text prependPtr: line6 length: strlen(line6)] ;
	[text prependPtr: line7 length: strlen(line7)] ;
	[text print: output] ;
	[output putPtr: "---- end of prepend line(s) No.3 :\n"] ;
	[output flush] ;

	[output putPtr: "---- append line(s) No.1:\n"] ;
	[text appendPtr: line4 length: strlen(line4)] ;
	[text print: output] ;
	[output putPtr: "---- end of append line(s) No.1:\n"] ;
	[output flush] ;

	[output putPtr: "---- append line(s) No.2:\n"] ;
	[text appendPtr: line5 length: strlen(line5)] ;
	[text print: output] ;
	[output putPtr: "---- end of append line(s) No.2:\n"] ;
	[output flush] ;

	[output putPtr: "---- append line(s) No.3:\n"] ;
	[text appendPtr: line6 length: strlen(line6)] ;
	[text appendPtr: line7 length: strlen(line7)] ;
	[text print: output] ;
	[output putPtr: "---- end of append line(s) No.3:\n"] ;
	[output flush] ;

	[output putPtr: "---- remove top/bottom empty lines:\n"] ;
	[text removeBothEmptyLines] ;
	[text print: output] ;
	[output putPtr: "---- end of remove top/bottom empty lines:\n"] ;
	[output flush] ;

	[output putPtr: "---- insert spaces before each lines\n"] ;
	[text foreach: @selector(indent:) with: PTR2ID("***") with: nil] ;
	[text print: output] ;
	[output putPtr: "---- end of insert spaces before each lines\n"] ;
	[output flush] ;

	[output putPtr: "---- concatenate all strings\n"] ;
	concat = [text concatenate] ;
	[output putStr: concat] ;
	[output putPtr: "---- end of concatenate all strings\n"] ;
	[output flush] ;

	[output putPtr: "---- clear\n"] ;
	[text clear] ;
	[text print: output] ;

	[output putPtr: "---- one more simple lines\n"] ;
	[text appendPtr: line8 length: strlen(line8)] ;
	[text removeBothEmptyLines] ;
	[text print: output] ;

	[output putPtr: "---- append indented lines:\n"] ;
	[text prependPtr: line9 length: strlen(line9)] ;
	[text removeLeftSpaces: 3 tab: 0] ;
	[text print: output] ;

	[output putPtr: "---- releasing ...\n"] ;
	[text release] ;
	[output release] ;
	[outfile release] ;
	printf("bye\n");
	return 0 ;
}

