/*****
 NAME
  	csystem-test2.m - test program for CSystem class
 VERSION
 	$Id$
 CHANGELOG
 	$Log$
 */

#include <coconut/csystem.h>
#include <stdio.h>
#include <stdlib.h>

@interface CSystemWrapper : CSystem <PSystem>
{
}

@end

@implementation CSystemWrapper

- (id <PError>) prologue: (int) argc argv: (const char **) argv
{
	printf("prologue.\n") ;
	printf("usage:\n") ;
	[self printUsage] ;
	return [super prologue: argc argv:argv] ;
}

- (const utf8_char *) helpString
{
	return [super helpString] ;
}

- (id <PError>) setupOption: (id <POptParser>) parser
{
	printf("setup options.\n") ;
	return [super setupOption: parser] ;
}

- (id <PError>) decodeOption: (id <POptParser>) parser
{
	printf("decode options.\n") ;
	return [super decodeOption: parser] ;
}

- (id <PError>) analyzeOption: (id <POptParser>) parser
{
	printf("analyze options.\n") ;
	return [super analyzeOption: parser] ;
}

- (id <PError>) main
{
	printf("main.\n") ;
	printf("the application name is \"%s\"\n", [CSystem applicationName]) ;
	return [super main] ;
}

- exitMainLoop: (id <PError>) err
{
	printf("exitMainLoop : code %d\n", err ? [err code] : 0) ;
	return [super exitMainLoop: err] ;
}

- (u_int) getMainLoopNest
{
	printf("getMainLoopNest:\n");
	return [super getMainLoopNest] ;
}

- retainMainLoop
{
	printf("retainMainLoop:\n");
	return [super retainMainLoop] ;
}

- releaseMainLoop: (id <PError>) err
{
	printf("releaseMainLoop: code %d\n", err ? [err code] : 0);
	return [super releaseMainLoop: err] ;
}

- (id <PError>) epilogue: (id <PError>) preerror
{
	printf("epilogue.\n") ;
	return [super epilogue: preerror] ;
}

- (id <PObstack>) systemObstack
{
	printf("systemObstack\n") ;
	return [super systemObstack] ;
}

- (id <PError>) recoverPrologue: (id <PError>) preerror
{
	printf("recoverPrologue\n") ;
	return [super recoverPrologue: preerror] ;
}

- (id <PError>) recoverMain: (id <PError>) preerror
{
	printf("recoverMain\n") ;
	return [super recoverMain: preerror] ;
}

- (id <PError>) recoverEpilogue: (id <PError>) preerror
{
	printf("recoverEpilogue\n") ;
	return [super recoverEpilogue: preerror] ;
}

- printUsage
{
	printf("this software is useless. (^_^;)\n") ;
	return nil ;
}

- printVersion
{
	printf("this is test program. the version is changed day by day.\n") ;
	return nil ;
}

@end

int main(int argc, const char **argv){
	id system ;
	int status ;
	printf("argv[0] = %s\n", &(argv[0][0])) ;
	system = [[CSystemWrapper alloc] init] ;
	status = start_program(system, argc, argv) ;
	[system printUsage] ;
	[system printVersion] ;
	printf("bye (code %d)\n", status) ;
	return status ;
}

