/*****
 NAME
 	cstack-test.m - test program for CStack class
 VERSION
 	$Id$
 CHANGELOG
 	$Log$
 */

#include <coconut/cstack.h>
#include <stdio.h>
#include <stdlib.h>

void print_stack(CStack * stack)
{
	int	idx ;
	int	*valp ;

	printf("--- content of stack\n") ;
	idx = [stack count] ;
	printf(" elm num : %d\n", idx) ;
	for(idx-- ; idx >= 0 ; idx--){
		valp = (int *) [stack peek: idx] ;
		printf(" %d: value = %d\n", idx, *valp) ;
	}
	printf("--- end\n") ;
}

int main()
{
	CStack *	stack ;
	int		val ;
	int *		valp ;
	int		i ;

	printf("*** test program for CStack class.\n") ;
	stack = [[CStack alloc] initStack: sizeof(int)] ;

	printf("initial state:\n");
	print_stack(stack) ;

	val = 100 ;
	printf("push %d\n", val) ;
	[stack push: &val] ;
	print_stack(stack) ;

	printf("push 24 times.\n");
	for(i=0; i<24 ; i++){
		printf("push %d\n", i) ;
		[stack push: &i];
	}
	print_stack(stack) ;

	printf("peek top -> %d\n", *((int *) [stack peekTop])) ;
	printf("peek 0 -> %d\n", *((int *) [stack peek: 0])) ;
	printf("peek 2 -> %d\n", *((int *) [stack peek: 2])) ;
	printf("peek 5 -> %d\n", *((int *) [stack peek: 5])) ;

	printf("pop 40 times.\n");
	for(i=0 ; i<40 ; i++){
		valp = (int *) [stack pop] ;
		printf("%d: -> result: ", i) ;
		if(valp)
			printf("%d\n", *valp) ;
		else
			printf("NULL\n");
	}

	printf("clear.\n") ;
	[stack clear] ;
	print_stack(stack) ;

	[stack release] ;
	printf("bye.\n") ;
	return 0 ;
}

