/*****
 NAME
	cset-test.m - test program for CSet class
 VERSION
	$Id$
 CHANGELOG
	$Log$
 */

#include <coconut/cset.h>
#include <coconut/cindtstream.h>
#include <stdlib.h>

const void * printElm(const void * data, const void * p1, const void * p2)
{
	id <PIndentStream>	stream = (id <PIndentStream>) p1 ;
	fflush(stdout) ;
	[stream putFormat: "%5.2lf, ", *((double *) data) ] ;
	[stream flush] ;
	return NULL ;
}

void print_set(const char * msg, id <PIndentStream> stream, id <PDataSet> set)
{
	printf("----- %s\n", msg) ;
	printf("elm num : %d\n", [set count]) ;
	printf("elm: ") ;
	[set foreach: &printElm with: stream with: NULL] ;
	printf("\n") ;
	printf("----- end of %s\n", msg) ;
}

void append(id <PDataSet> set, double val)
{
	[set append: &val] ;
}

int main()
{
	id <PIndentStream>	stream ;
	id <PDataSet>		set ;
	double			d ;

	printf("*** test program for CSet class\n") ;
	set = [[CSet alloc] initSet: sizeof(double)] ;
	stream = [[CIndtStream alloc] init] ;

	print_set("initial state", stream, set) ;

	append(set, 1.0) ;
	print_set("1 data appended", stream, set) ;

	printf("appending:") ;
	for(d=2.0 ; d<12.0 ; d+=0.5){
		printf("  %5.2lf, ", d) ;
		append(set, d) ;
	}
	printf("\n") ;
	print_set("many data appended", stream, set) ;

	printf("more appending:") ;
	for(d=2.0 ; d<120.0 ; d+=0.5){
		printf("  %5.2lf, ", d) ;
		append(set, d) ;
	}
	printf("\n") ;
	print_set("more many many data appended", stream, set) ;

	[stream flush] ;
	[stream release] ;
	[set release] ;
	printf("bye.\n") ;
	exit(0) ;
}

