/*****
 NAME
 	cseparator-test.m
 VERSION
 	$Id$
 CHANGELOG
 	$Log$
 */

#include <coconut/gtk/cguisystem.h>
#include <coconut/gtk/ccontainer.h>
#include <coconut/gtk/cseparator.h>
#include <coconut/gtk/clabel.h>
#include <coconut/gtk/cwindow.h>
#include <coconut/papplication.h>

@interface CSeparatorTest : CGUISystem <PApplication>
{
	CWindow *	window ;
	CContainer *	container ;
	CLabel *	toplabel ;
	CSeparator *	separator ;
	CLabel *	bottomlabel ;
}

@end

@implementation CSeparatorTest
- (id <PError>) prologue: (int) argc argv: (const char **) argv
{
	printf("prologue\n");
	return [super prologue: argc argv:argv] ;
}

- (id <PError>) main
{
	printf("main\n") ;

	printf("initialize window\n") ;
	window = [[CWindow alloc] initWindow: window_toplevel align: 
	  screen_align_center] ;

	printf("initialize the container\n") ;
	container = [[CContainer alloc] initContainer: TRUE homogeneous: TRUE
	  spacing: 2] ;

	printf("initialize top label\n") ;
	toplabel = [[CLabel alloc] initLabel: "Top Label"] ;

	printf("initialize separator\n") ;
	separator = [[CSeparator alloc] initSeparator: FALSE] ;

	printf("initialize bottom label\n") ;
	bottomlabel = [[CLabel alloc] initLabel: "Bottom Label"] ;

	printf("add labels and separator to container\n") ;
	[container appendWidget: toplabel] ;
	[container appendWidget: separator] ;
	[container appendWidget: bottomlabel] ;

	printf("add container to window\n") ;
	[window appendWidget: container] ;

	printf("showing window at the center of screen\n"
	  "*** If you see the 2 labels and a separator in the window,\n"
	  "*** please close the window. And if you not see the message,\n"
	  "*** it's error. press \"C\" key with Control key\n") ;
	[window doExitAfterDelete] ;
	[window show] ;
	printf("main routine.\n") ;
	return [super main] ;
}

- (id <PError>) epilogue: (id <PError>) preerror
{
	printf("epilogue\n");
	return [super epilogue: preerror] ;
}

@end

int main(int argc, const char **argv){
	id system ;
	int status ;

	printf("argv[0] = %s\n", &(argv[0][0])) ;
	system = [[CSeparatorTest alloc] init] ;
	status = start_program(system, argc, argv) ;
	[system release] ;
	printf("bye (code %d, %s)\n", status, [CSystem applicationName]) ;
	return status ;
}

