/*****
 NAME
 	cregexp-test.m - test program for CRegExp class
 VERSION
 	$Id$
 CHANGELOG
 	$Log$
 */

#include <coconut/cregexp.h>
#include <stdio.h>
#include <stdlib.h>

int main()
{
	id		regexp ;
	id <PError>	err ;
	char		pat1[] = "H[el]*o" ;
	char		illegalpat[] = "hoge[" ;
	char		str1[] = "Goodbye" ;
	char		str2[] = "Hello" ;
	char		str3[] = "Welcome, Hello, Goodbye" ;
	off_t		start, stop ;

	printf("*** test program for CRegExp class.\n") ;
	regexp = [[CRegExp alloc] init] ;

	/* compile pattern */
	err = [regexp compile: pat1] ;
	printf("compile \"%s\" ... result: %d\n", pat1, [err code]) ;

	/* match pattern */
	start = stop = -1 ;
	err = [regexp match: str1 start:&start stop:&stop] ;
	printf("match \"%s\" ... result: %d (%d,%d)\n", str1, [err code],
	  (int) start, (int) stop) ;

	start = stop = -1 ;
	err = [regexp match: str2 start:&start stop:&stop] ;
	printf("match \"%s\" ... result: %d (%d,%d)\n", str2, [err code],
	  (int) start, (int) stop) ;

	start = stop = -1 ;
	err = [regexp match: str3 start:&start stop:&stop] ;
	printf("match \"%s\" ... result: %d (%d,%d)\n", str3, [err code],
	  (int) start, (int) stop) ;

	/* compile illegal pattern */
	err = [regexp compile: illegalpat] ;
	printf("compile \"%s\" ... result: %d\n", pat1, [err code]) ;
	printf("message: \"%s\"\n", [regexp getErrorStr]) ;

	[regexp release] ;
	printf("bye.\n");
	exit(0) ;
}

