/*****
 NAME
 	crect-test.m - test program for CRect
 VERSION
 	$Id$
 CHANGELOG
 	$Log$
 */

#include <coconut/crect.h>
#include <stdlib.h>

void printRect(id <PRect> rect)
{
	printf("left %d, top %d, right %d, bottom %d, width %d, height %d\n", 
	  [rect left], [rect top], [rect right], [rect bottom],
	  [rect width], [rect height]) ;
}

int main()
{
	CRect *	rect1 ;
	CRect * rect2 ;

	printf("*** test program for CRect class\n") ;
	rect1 = [[CRect alloc] init] ;
	
	printf("initial state :\n");
	printRect(rect1) ;

	printf("set method:\n") ;
	[rect1 set: 10 and: 20 and: 30 and: 40] ;
	printRect(rect1) ;

	printf("setCorner method:\n") ;
	[rect1 setCorner: 110 and: 120] ;
	printRect(rect1) ;

	printf("setSize method:\n") ;
	[rect1 setSize: 130 and: 140] ;
	printRect(rect1) ;

	printf("setLeft method:\n") ;
	[rect1 setLeft: 15] ;
	printRect(rect1) ;

	printf("setTop method:\n") ;
	[rect1 setTop: 25] ;
	printRect(rect1) ;

	printf("setRight method:\n") ;
	[rect1 setRight: 40] ;
	printRect(rect1) ;

	printf("setBottom method:\n") ;
	[rect1 setBottom: 70] ;
	printRect(rect1) ;

	printf("new rect2:\n") ;
	rect2 = [[CRect alloc] initRect: 20 and: 30 and: 40 and: 50] ;
	printRect(rect2) ;

	printf("copy method:\n") ;
	[rect1 copy: rect2] ;
	printRect(rect1) ;

	printf("move method:\n") ;
	[rect1 move: 15 and: 25] ;
	printRect(rect1) ;

	printf("grow method:\n") ;
	[rect1 grow: 5 and: 5] ;
	printRect(rect1) ;

	printf("union method:\n");
	printf("rect1: ") ; printRect(rect1) ;
	printf("rect2: ") ; printRect(rect2) ;
	printf("result : %d\n", (int) [rect1 union: rect2]) ;
	printRect(rect1) ;

	[rect1 release] ;
	exit(0) ;
}

