/*****
 NAME
	creal-test.m 
 VERSION
	$Id$
 CHANGELOG
	$Log$
 */

#include <coconut/creal.h>
#include <coconut/cint.h>

void print_values(id <PNumber> i1, id <PNumber> i2, id <PNumber> d1, 
  id <PNumber> d2)
{
	printf("i1=%d, i2=%d d1=%f d2=%f\n", [i1 intNum], [i2 intNum],
 	  [d1 realNum], [d2 realNum]) ;
}

int main()
{
	id <PNumber> i1, i2 ;
	id <PNumber> d1, d2 ;

	printf("*** test program for CReal class\n") ;
	i1 = [[CInt alloc] init] ;
	i2 = [[CInt alloc] init] ;
	d1 = [[CReal alloc] init] ;
	d2 = [[CReal alloc] init] ;
	printf("initial state:\n") ;
	print_values(i1, i2, d1, d2) ;

	printf("set methods:\n") ;
	[i1 setInt: 1.5] ;
	[i2 setReal: 2.5] ;
	[d1 setInt: 1.5] ;
	[d2 setReal: 2.5] ;
	print_values(i1, i2, d1, d2) ;
	[d1 setObject: d2] ;
	[d2 setReal: 3.14] ;
	print_values(i1, i2, d1, d2) ;

	printf("get methods:\n");
	[d1 setReal: [d2 intNum]] ;
	print_values(i1, i2, d1, d2) ;
	[d1 setReal: [d2 realNum]] ;
	print_values(i1, i2, d1, d2) ;

	printf("add methods:\n");
	[d1 addObject: i1] ;
	[i2 addObject: d2] ;
	[d2 addInt: [i2 intNum]] ;
	[i1 addReal: [d1 realNum]] ;
	print_values(i1, i2, d1, d2) ;
	[d1 addReal: [d2 realNum]] ;
	print_values(i1, i2, d1, d2) ;

	printf("duplicate:\n") ;
	print_values(i1, [i1 duplicate], d1, [d1 duplicate]);

	[i1 release] ; [i2 release] ;
	[d1 release] ; [d2 release] ;
	printf("bye.\n") ;
	return 0 ;
}

