/*****
 NAME
 	cradiobutton-test.m - test program for CRadioButton class
 VERSION
 	$Id$
 CHANGELOG
 	$Log$
 */

#include <coconut/gtk/cradiobutton.h>
#include <coconut/gtk/clabel.h>
#include <coconut/gtk/cguisystem.h>
#include <coconut/gtk/cwindow.h>
#include <coconut/papplication.h>

@interface CRadioButtonTest : CGUISystem <PApplication>
{
	CWindow *	window ;
	CRadioButton *	radio ;
}

@end

@implementation CRadioButtonTest
- (id <PError>) prologue: (int) argc argv: (const char **) argv
{
	printf("prologue\n");
	return [super prologue: argc argv:argv] ;
}

- (id <PError>) main
{
	printf("main\n") ;

	printf("initialize window\n") ;
	window = [[CWindow alloc] initWindow: window_toplevel align: 
	  screen_align_center] ;

	printf("initialize radio button\n") ;
	radio = [[CRadioButton alloc] initRadioButton: TRUE] ;

	printf("add radio button to window\n") ;
	[window appendWidget: radio] ;

	printf("add label to radio button\n");
	[radio appendLabel: "button 1"] ;
	[radio appendLabel: "button 2"] ;
	[radio prependLabel: "button 0"] ;
	[radio activate: 0] ;

	printf("showing window at the center of screen\n"
	  "*** if the error is occured. press \"C\" key with Control key\n") ;
	[window doExitAfterDelete] ;
	[window show] ;
	printf("main routine.\n") ;
	return [super main] ;
}

- (id <PError>) epilogue: (id <PError>) preerror
{
	printf("epilogue\n");
	return [super epilogue: preerror] ;
}

@end

int main(int argc, const char **argv){
	id system ;
	int status ;

	printf("argv[0] = %s\n", &(argv[0][0])) ;
	system = [[CRadioButtonTest alloc] init] ;
	status = start_program(system, argc, argv) ;
	[system release] ;
	printf("bye (code %d, %s)\n", status, [CSystem applicationName]) ;
	return status ;
}

