/*****
 NAME
	cpagealloc-test.m - test program for CPageAlloc class
 VERSION
	$Id$
 CHANGELOG
	$Log$
 */

#include <coconut/cpagealloc.h>
#include <stdio.h>
#include <stdlib.h>

void fill_mem(void * ptr, size_t size)
{
	byte * start ;
	byte * stop ;
	start = (byte *) ptr ; stop = start + size ;
	for( ; start < stop ; start++){
		*start = 0x00 ;
	}
}

int check_mem(void * ptr, size_t size){
	byte *	start;
	byte *	stop ;
	start = (byte *) ptr ; stop = start + size ;
	for( ; start < stop ; start++){
		if(*start != 0x00)
			return 0 ;
	}
	return 1 ;
}

int main()
{
	id <PAllocator>	allocator ;
	void * 		ptr ;

	printf("*** test program for CPageAlloc class\n") ;
	allocator = [[CPageAlloc alloc] init] ;
	
	printf("allocate 1024 bytes for the CPageAlloc object.\n");
	ptr = [allocator allocate: 1024] ;
	fill_mem(ptr, 1024) ;
	printf("result : %s\n", check_mem(ptr,1024) ? "OK" : "BAD") ;

	printf("allocate 2048 bytes for the CPageAlloc object.\n");
	ptr = [allocator allocate: 2048] ;
	fill_mem(((byte *) ptr)+1024, 1024) ;
	printf("result : %s\n", check_mem(ptr,2048) ? "OK" : "BAD") ;

	[allocator free: ptr] ;
	[allocator release] ;
	printf("bye.\n") ;
	exit(0) ;
}

