/*****
 NAME
	cobstack-test.m - test program for CObstack class
 VERSION
	$Id$
 CHANGELOG
	$Log$
 */

#include <coconut/cobstack.h>
#include <stdio.h>
#include <stdlib.h>

void set_str(void * p, char c, size_t s)
{
	char *	start = (char *) p ;
	char *	stop  = start + s - 1 ;

	for( ; start < stop ; start++){
		*start = c ;
		c = c == 'z' ? 'a' : c+1 ;
	}
	*start = '\0' ;
}

int main()
{
	id 	obstack ;
	void *	ptr ;
	char	message1[] = "this is a test string." ;
	size_t	size ;

	printf("*** test program for CObstack class\n"); 
	obstack = [[CObstack alloc] init] ;

	printf("allocate string:\n") ;
	ptr = [obstack allocate: 12] ;
	set_str(ptr, 'a', 12) ;
	printf("ptr : \"%s\"\n", (char *) ptr) ;

	printf("reallocate string:\n") ;
	ptr = [obstack reallocate: ptr size: 16] ;
	printf("ptr : \"%s\"\n", (char *) ptr) ;
	set_str(ptr, 'b', 16) ;
	printf("ptr : \"%s\"\n", (char *) ptr) ;

	printf("set string:\n");
	ptr = [obstack allocate: size = strlen(message1)+1] ;
	memmove(ptr, message1, size) ;
	printf("ptr : \"%s\"\n", (char *) ptr) ;

	printf("dealocation (ignored):\n");
	[obstack free: ptr] ;
	[obstack release] ;
	printf("bye.\n");
	exit(0) ;
}

