/*****
 NAME
	cobject-test.m - test program for CObject class
 VERSION
	$Id$
 CHANGELOG
	$Log$
 */

#define	COBJECT_TEST

#include <coconut/cobject.h>
#include <coconut/cmessage.h>
#include <stdio.h>

@interface CWrapper : CObject
{
}

- (const char *) name ;

- retain ;
- (oneway void) release ;
- (void) dealloc ;

@end

@implementation CWrapper
- (const char *) name
{
	static const char name[] = "CWrapper" ;
	return name ;
}

- retain
{
	printf("retain method:\n");
	return [super retain] ;
}

- (oneway void) release
{
	printf("release (count %d):\n", [self retainCount]) ;
	[super release] ;
}

- (void) dealloc
{
	printf("dealloc:\n") ;
	[super dealloc] ;
}

@end

int main()
{
	id obj ;

	printf("*** test program for CObject class\n") ;

	obj = [[CWrapper alloc] init] ;

	printf("print messages to stderr:\n") ;
	[CMessage message: note_message code: 0 
	  format: "%d + %d = %s", 1, 2, "3"] ;
	[CMessage message: warning_message code: 0 format: ""] ;
	[CMessage message: error_message code: (int) no_error 
	  format: "this is %s error", "not"] ;

	[obj retain] ;
	[obj retain] ;

	[obj release] ;
	[obj release] ;
	[obj release] ;

	printf("bye.\n") ;
	return 0 ;
}

