/*
 NAME
 	cnode-test.m - test program for CNode class
 VERSION
 	$Id$
 CHANGELOG
 	$Log$
 */

#include <coconut/cnode.h>
#include <coconut/cstring.h>
#include <coconut/cindtstream.h>

@interface CNodeWrapper : CNode 
{
	utf8_char *		msg_str ;
}
- initNodeWrapper: (const utf8_char *) msg ;
- print: (id) stream ;
- removeAllChildren ;
- isolate ;
@end

@implementation CNodeWrapper

- initNodeWrapper: (const utf8_char *) msg
{
	msg_str = [CString duplicate: msg] ;
	printf("* allocate: %s\n", msg_str) ;
	return [super init] ;
}

- (void) dealloc
{
	printf("* release: %s\n", msg_str) ;
	[CString free: msg_str] ;
	[super dealloc] ;
}

- removeAllChildren
{
	printf("* removing all children:\n") ;
	return [super removeAllChildren] ;
}

- isolate
{
	printf("* isolating all children:\n") ;
	return [super isolate] ;
}

#define	STREAM	((id <PIndentStream>) stream)
- print: (id) stream
{
	[STREAM putPtr: msg_str] ;
	[STREAM putChar: '\n'] ;
	return [super print: stream] ;
}

@end

int main()
{
	CIndtStream *	stream ;
	CNodeWrapper *	node1 ;
	CNodeWrapper *	node2 ;
	CNodeWrapper *	node3 ;
	CNodeWrapper *	node4 ;
	CNodeWrapper *	node5 ;

	printf("*** test program for CNode class\n") ;

	stream = [[CIndtStream alloc] init] ;
	node1 = [[CNodeWrapper alloc] initNodeWrapper: "node1"] ;
	node2 = [[CNodeWrapper alloc] initNodeWrapper: "node2"] ;
	node3 = [[CNodeWrapper alloc] initNodeWrapper: "node3"] ;
	node4 = [[CNodeWrapper alloc] initNodeWrapper: "node4"] ;
	node5 = [[CNodeWrapper alloc] initNodeWrapper: "node5"] ;

	/* operation */
	printf("initial status:\n") ; fflush(stdout) ;
	[node1 print: stream] ; [stream flush] ;

	printf("add node3 to node2:\n") ; fflush(stdout) ;
	[node2 addSibling: node3] ; [node3 release] ;
	[node2 foreach: @selector(print:) with: stream with: nil] ;
	[stream flush] ;

	printf("insert node 1 to node2:\n") ; fflush(stdout) ;
	[node2 insertSibling: node1] ; [node1 release] ;
	[node1 foreach: @selector(print:) with: stream with: nil] ;
	[stream flush] ;

	printf("append node 4 and 5 to node 1 as a child:\n") ;
	[node1 appendChild: node5] ; [node5 release] ;
	[node1 prependChild: node4] ; [node4 release] ;
	[node1 foreach: @selector(print:) with: stream with: nil] ;
	[stream flush] ;

	printf("foreach nodes from children:\n") ; fflush(stdout) ;
	[node1 foreachFromChildren: @selector(print:) with: stream 
	  with: nil] ;
	[stream flush] ;

	printf("remove all children of node1:\n") ;
	[node1 removeAllChildren] ;

	printf("releasing rest node2 and print node1:\n");
	[node2 release] ;
	[node1 print: stream] ;
	[stream flush] ;

	printf("releasing rest node3 and print node1:\n");
	[node3 release] ;
	[node1 print: stream] ;
	[stream flush] ;

	printf("releasing rest node1:\n");
	[node1 release] ;

	printf("bye.\n") ; 
	return 0 ;
}

