/*****
 NAME
 	cnetstream-test.m - test program for CNetStream class
 VERSION
 	$Id$
 CHANGELOG
 	$Log$
 */

#include <coconut/gnet/cnetclient.h>
#include <coconut/gnet/cnetserver.h>
#include <coconut/cstring.h>
#include <stdlib.h>

#define	PORTNUM	12044

void check_error(id <PError> err)
{
	if(err == nil)
		printf("OK\n") ;
	else
		printf("ERROR OCCURED (code %x)\n", [err code]) ;
}

int main()
{
	id <PNetClient>		net_client ;
	id <PNetServer>		net_server ;
	id <PConstStr>		line ;
	id <PError>		err ;
	const utf8_char 	server_str[] = "server" ;

	printf("*** test program for CNetClient and CNetServer class\n");
	net_client = [[CNetClient alloc] init] ;
	net_server = [[CNetServer alloc] init] ;

	printf("open the server ... ");
	err = [net_server open: PORTNUM connect: FALSE ] ;
	check_error(err) ;

	printf("open the client ... ");
	err = [net_client open: PORTNUM server: "localhost"] ;
	check_error(err) ;

	printf("connecting ... %s\n", [net_server connect] ? "OK" : "FAILED") ;

	printf("send message from server:\n") ;
	[net_server putFormat: "Hello, this is server %s.\n", server_str] ;

	printf("receive message by client:\n") ;
	printf("CAUTION: if the program is stopped here, it means the BUG.\n"
	  "press CTRL-C key to abort this process.\n");

	line = [net_client getLine] ;
	printf(" the message is \"%s\", size %d\n", [line ptr], [line size]) ;
	[line release] ;

	[net_client close] ;
	[net_server close] ;

	[net_client release] ;
	[net_server release] ;
	printf("bye.\n") ;
	exit(0);
}

