/*****
 NAME
 	cmessage-test.m - test program for CMessage class
 VERSION
 	$Id$
 CHANGELOG
 	$Log$
 */

#include <coconut/cmessage.h>
#include <stdlib.h>

void makeFile(char *buf, const char * fname, u_int lineno) 
{
	u_int	len ;
	size_t	slen ;

	len = [CMessage makeFileMessage: buf file: fname lineno: lineno] ;
	if((slen = strlen(buf)) == len)
		printf("size of buffer : %u\n", len);
	else {
		printf("ERROR:\n") ;
		printf("different buffer size: result %u, buf %u\n", len, slen);
		exit(1) ;
	}
	printf("content of buffer: \"%s\"\n", buf);
}

void makeCategory(char * buf, message_t type, int code)
{
	u_int	len ;
	size_t	slen ;

	len = [CMessage makeCategoryMessage: buf type: type code: code] ;
	if((slen = strlen(buf)) == len)
		printf("size of buffer : %u\n", len);
	else {
		printf("ERROR:\n") ;
		printf("different buffer size: result %u, buf %u\n", len, slen);
		exit(1) ;
	}
	printf("content of buffer: \"%s\"\n", buf);
}

int main()
{
	char	buf[MSG_BUF_SIZE] ;

	printf("*** test program for CMessage class\n");

	printf("--- test makeFileMessage method:\n") ;
	makeFile(buf, "filename", 123) ;
	makeFile(buf, NULL, 123) ;

	printf("--- test makeCategoryMessage method:\n") ;
	makeCategory(buf, note_message, 0) ;
	makeCategory(buf, warning_message, 0) ;
	makeCategory(buf, error_message, 100) ;

	return 0 ;
}

