/*****
 NAME
 	clangsystem-test.m - header file for CLangSystem
 VERSION
 	$Id$
 CHANGELOG
 	$Log$
 */

#include <coconut/clangsystem.h>
#include <coconut/cindtstream.h>
#include <coconut/flang.h>
#include <stdlib.h>

int main()
{
	id <PLangSystem>	system ;
	id <PIndentStream>	output ;
	id <PToken>		token1 ;

	printf("*** test program for CLangSystem class\n");
	system = [[CLangSystem alloc] init] ;
	output = [[CIndtStream alloc] init] ;

	printf("test for lex string operations:\n") ;
	startLexString() ;
	addLexString('H') ;
	addLexString('e') ;
	addLexString('l') ;
	addLexString('l') ;
	addLexString('o') ;
	printf("1st string : \"%s\"\n", finishLexString()) ;

	startLexString() ;
	addLexString('W') ;
	addLexString('e') ;
	addLexString('l') ;
	addLexString('c') ;
	addLexString('o') ;
	addLexString('m') ;
	addLexString('e') ;
	printf("2nd string : \"%s\"\n", finishLexString()) ;

	printf("lex error:\n") ;
	syntaxError(10, "hello") ;
	setLexInputName("clangsystem-test.m") ;
	syntaxError(100, "world") ;

	printf("double data token:\n") ;
	fflush(stdout) ;
	token1 = doubleTextToToken(0, "10.0") ;
	[token1 print: output] ;
	[output putPtr: "\nfollowing command generates error:\n"] ;
	token1 = doubleTextToToken(0, "hogehoge") ;
	[token1 print: output] ;
	[output putChar: '\n'] ;
	
	[output putPtr: "int data to token: 255, 0xff, 0377\n"] ;
	token1 = intTextToToken(1, "255", 10) ;
	[token1 print: output] ;
	[output putChar: '\n'] ;
	token1 = intTextToToken(1, "ff", 16) ;
	[token1 print: output] ;
	[output putChar: '\n'] ;
	token1 = intTextToToken(1, "0377", 8) ;
	[token1 print: output] ;
	[output putChar: '\n'] ;

	[output putPtr: "const str to token:\n"] ;
	token1 = constStrToToken("this is const str") ;
	[token1 print: output] ;

	[output putPtr: "\ncontent of hash tables"] ;
	[system print: output] ;

	[output flush] ;
	[system release] ;
	[output release] ;
	printf("bye\n") ;
	exit(0) ;
}

