/*****
 NAME
 	clabel-test.m
 VERSION
 	$Id$
 CHANGELOG
 	$Log$
 */

#include <coconut/gtk/cguisystem.h>
#include <coconut/gtk/clabel.h>
#include <coconut/gtk/cwindow.h>
#include <coconut/papplication.h>

@interface CLabelTest : CGUISystem <PApplication>
{
	CWindow *	window ;
	CLabel *	label ;
}

@end

@implementation CLabelTest
- (id <PError>) prologue: (int) argc argv: (const char **) argv
{
	printf("prologue\n");
	return [super prologue: argc argv:argv] ;
}

- (id <PError>) main
{
	printf("main\n") ;

	printf("initialize window\n") ;
	window = [[CWindow alloc] initWindow: window_toplevel align: 
	  screen_align_center] ;

	printf("initialize label\n") ;
	label = [[CLabel alloc] initLabel: "Hello, World!!"] ;

	printf("add label to window\n") ;
	[window appendWidget: label] ;

	printf("showing window at the center of screen\n"
	  "*** If you see the \"hello world\" message window,\n"
	  "*** please close the window. And if you not see the message,\n"
	  "*** it's error. press \"C\" key with Control key\n") ;
	[window doExitAfterDelete] ;
	[window show] ;
	printf("main routine.\n") ;
	return [super main] ;
}

- (id <PError>) epilogue: (id <PError>) preerror
{
	printf("epilogue\n");
	return [super epilogue: preerror] ;
}

@end

int main(int argc, const char **argv){
	id system ;
	int status ;

	printf("argv[0] = %s\n", &(argv[0][0])) ;
	system = [[CLabelTest alloc] init] ;
	status = start_program(system, argc, argv) ;
	[system release] ;
	printf("bye (code %d, %s)\n", status, [CSystem applicationName]) ;
	return status ;
}

