/*****
 NAME
 	cindtstream.h - header file for CIndtStream class
 VERSION
 	$Id$
 CHANGELOG
 	$Log$
 */

#include <coconut/cindtstream.h>
#include <stdlib.h>

void check(io_status_t stat)
{
	if(stat != io_status_normal){
		printf("ERROR code %d\n", (int) stat) ;
		exit(1) ;
	}
}

int main()
{
	id <PIndentStream>	stream ;
	char msg1[] = "hello, world\n" ;
	char msg2[] = "who is bad\n" ;
	int  i ;

	printf("**** test program for CIndtStream\n") ;

	stream = [[CIndtStream alloc] initIndtStreamWithUnit: "->"] ;
	check([stream putChar: 'a']) ;
	check([stream putChar: '\n']) ;
	[stream incLevel] ;
	check([stream putChar: 'b']) ;
	check([stream putChar: '\n']) ;
	[stream decLevel] ;
	check([stream putChar: 'c']) ;
	check([stream putChar: '\n']) ;
	[stream flush] ;

	[stream putFormat: "%d)", [stream level]] ;
	[stream putPtr: msg1 length: strlen(msg1)] ;
	[stream incLevel] ;
	[stream putFormat: "%d)", [stream level]] ;
	[stream putPtr: msg2] ;
	[stream incLevel] ;
	[stream putFormat: "%d)", [stream level]] ;
	[stream putFormat: "this is \"%s\" string\n", "formatted"] ;

	/* ascii code only */
	for(i=0 ; i<10 ; i++){
		[stream incLevel] ; [stream putFormat: "%c\n", 'a'+i] ;
	}
	for(i=0 ; i<15 ; i++){
		[stream decLevel] ; [stream putFormat: "%c\n", 'z'-i] ;
	}
		
	[stream flush] ;
	[stream release] ;
	printf("bye\n");
	exit(0) ;
}

