/*****
 NAME
 	cindent-test.m - test program for CIndent class
 VERSION
 	$Id$
 CHANGELOG
 	$Log$
 */

#include <coconut/cindent.h>

void printIndent(const char * msg, id <PIndent> indent)
{
	const utf8_char *	content ;
	u_int			len ;
	u_int			level ;

	content = [indent ptr] ; len = strlen(content) ;
	level = [indent level] ;
	printf("[%s] %u(%u):\"%s\"\n", msg, level, len, content) ;
}

#define	SPACES	100

int main()
{
	id <PIndent>		indent ;
	utf8_char		spaces[SPACES+1] ;
	utf8_char *		ptr ;
	utf8_char *		end ;
	int			i ;

	printf("*** test program for CIndent class\n");

	/* easy test */
	indent = [[CIndent alloc] initIndent: "-"] ;
	printIndent("initial", indent) ;
	[indent incLevel] ;
	printIndent("2nd", indent) ;
	[indent incLevel] ;
	printIndent("3rd", indent) ;
	[indent decLevel] ;
	printIndent("4th", indent) ;
	[indent decLevel] ;
	printIndent("5th", indent) ;
	[indent decLevel] ;
	printIndent("6th", indent) ;
	[indent release] ;

	/* initialize test indent */
	ptr = &(spaces[0]) ; end = ptr + SPACES ;
	for( ; ptr<end ; ptr++)
		*ptr = '-' ;
	*ptr = '\0' ;
	indent = [[CIndent alloc] initIndent: spaces] ;
	printIndent("initial", indent) ;
	[indent incLevel] ;
	printIndent("2nd", indent) ;
	[indent incLevel] ;
	printIndent("3rd", indent) ;
	[indent decLevel] ;
	printIndent("4th", indent) ;
	[indent decLevel] ;
	printIndent("5th", indent) ;
	[indent decLevel] ;
	printIndent("6th", indent) ;

	for(i=0 ; i<20 ; i++)
		[indent incLevel] ;
	printIndent("more 20", indent) ;

	for(i=0 ; i<19 ; i++)
		[indent decLevel] ;
	printIndent("more 19 (minus)", indent) ;

	[indent release] ;

	printf("bye\n") ;
	return 0 ;
}

