/*****
 NAME
 	cidstack-test.m - test program for CIdStack class
 VERSION
 	$Id$
 CHANGELOG
 	$Log$
 */

#include <coconut/cidstack.h>
#include <coconut/cint.h>
#include <stdio.h>
#include <stdlib.h>

void print_stack(CIdStack * stack)
{
	id <PNumber>	num ;
	int		idx ;

	printf("--- content of stack\n") ;
	idx = [stack count] ;
	printf(" elm num : %d\n", idx) ;
	for(idx-- ; idx >= 0 ; idx--){
		num = [stack peek: idx] ;
		printf(" %d: value = %d\n", idx, [num intNum]) ;
	}
	printf("--- end\n") ;
}

void printInt(const char * msg, id num)
{
	printf(msg, [(id <PNumber>) num intNum]) ;
}

int main()
{
	CIdStack *	stack ;
	id <PNumber>	num ;
	int		val ;
	int		i ;

	printf("*** test program for CIdStack class.\n") ;
	stack = [[CIdStack alloc] init] ;

	printf("initial state:\n");
	print_stack(stack) ;

	val = 100 ; printf("push %d\n", val) ;
	[stack push: [CInt newInt: val format: dec_format]] ;
	print_stack(stack) ;

	printf("push 24 times.\n");
	for(i=0; i<24 ; i++){
		printf("push %d\n", i) ;
		[stack push: [CInt newInt: i format: dec_format]];
	}
	print_stack(stack) ;

	printInt("peek top -> %d\n", [stack peekTop]) ;
	printInt("peek 0 -> %d\n", [stack peek: 0]) ;
	printInt("peek 2 -> %d\n", [stack peek: 2]) ;
	printInt("peek 5 -> %d\n", [stack peek: 5]) ;

	printf("pop 40 times.\n");
	for(i=0 ; i<40 ; i++){
		num = [stack pop] ;
		printf("%d: -> result: ", i) ;
		if(num)
			printf("%d\n", [num intNum]) ;
		else
			printf("nil\n");
	}

	printf("clear.\n") ;
	[stack clear] ;
	print_stack(stack) ;

	[stack release] ;
	printf("bye.\n") ;
	return 0 ;
}

