/*****
 NAME
	cidset-test.m - test program for CIdSet class
 VERSION
	$Id$
 CHANGELOG
	$Log$
 */

#include <coconut/cidset.h>
#include <coconut/cindtstream.h>
#include <coconut/creal.h>
#include <stdlib.h>

void print_set(const char * msg, id <PIndentStream> stream, id <PIdSet> set)
{
	printf("----- %s\n", msg) ;
	printf("elm num : %d\n", [set count]) ;
	printf("elm: ") ;
	fflush(stdout) ;

	[set print: stream] ;
	[stream flush] ;

	printf("----- end of %s\n", msg) ;
}

int main()
{
	id <PIndentStream>	stream ;
	id <PIdSet>		set ;
	id <PNumber>		real ;
	double			d ;

	printf("*** test program for CIdSet class\n") ;
	set = [[CIdSet alloc] init] ;
	stream = [[CIndtStream alloc] init] ;
	real = [[CReal alloc] init] ;

	print_set("initial state", stream, set) ;

	[real setReal: 1.0] ; [set append: real] ; [real release] ;
	print_set("1 data appended", stream, set) ;

	printf("appending:") ;
	for(d=2.0 ; d<12.0 ; d+=0.5){
		printf(" data:  %f\n", d) ;
		real = [[CReal alloc] init] ;
		[real setReal: d] ;
		[set append: real] ;
		[real release] ;
	}
	printf("\n") ;
	print_set("many data appended", stream, set) ;

	[stream flush] ;
	[stream release] ;
	[set release] ;
	printf("bye.\n") ;
	exit(0) ;
}

