/*****
 NAME
	cidlist-test.m - test program for CIdList class
 VERSION
	$Id$
 CHANGELOG
	$Log$
 */

#include <coconut/cidlist.h>
#include <coconut/cmemalloc.h>
#include <coconut/cindtstream.h>
#include <coconut/cconststr.h>
#include <coconut/fbasic.h>
#include <stdio.h>
#include <stdlib.h>

void print_list(const char * msg, id <PIndentStream> stream, id <PIdList> list)
{
	id <PConstStr>	str ;
	printf("----- %s\n", msg) ;
	printf("elm num : %d\n", [list count]) ;
	fflush(stdout) ;

	[list print: stream] ;
	[stream flush] ;

	str = (id <PConstStr>) [list currentItem] ;
	printf("current data : %s\n", str ? [str ptr] : (const utf8_char *)
	  "<null>") ;
	printf("----- end of %s\n", msg) ;
	fflush(stdout) ;
}

void print_each_elm(id <PIdList> list){
	id <PConstStr>	str ;
	int		i ;

	printf("normal order:\n") ;
	str = [list moveToHead] ; i = 0 ; 
	while(str){
		printf("[%d] \"%s\"\n", i, [str ptr]) ;
		str = [list moveNext] ;
		i++ ;
	}

	printf("reverse order:\n") ;
	str = [list moveToTail] ; i-- ;
	while(str){
		printf("[%d] \"%s\"\n", i, [str ptr]) ;
		str = [list movePrev] ;
		i-- ;
	}
}

void print_each_elm2(id <PIdList> list){
	id <PConstStr>	str ;
	u_int		i ;

	printf("indexed print:\n") ;
	for(i=0 ; (str = (id <PConstStr>) [list item: i]) != NULL ; i++)
		printf("<%d> \"%s\"\n", i, [str ptr]) ;
}

int main()
{
	id <PIdList>		list ;
	id <PIndentStream>	stream ;
	id <PConstStr>		str ;

	printf("*** test program for CIdList class\n");
	list = [[CIdList alloc] init] ;
	stream = [[CIndtStream alloc] init] ;

	print_list("initial state", stream, list) ;

	str = [CConstStr newConstStr: "hello, this is 1st data"] ;
	[list append: str] ;
	[str release] ;

	str = [CConstStr newConstStr: "good morning, 2nd data !!"] ;
	[list append: str] ;
	[str release] ;

	print_list("2 data are appended", stream, list) ;

	str = [CConstStr newConstStr: "hi, this is 3rd data"] ;
	[list prepend: str] ;
	[str release] ;

	str = [CConstStr newConstStr: "whar do you think about 4th data?"] ;
	[list prepend: str] ;
	[str release] ;

	print_list("2 data are prepended", stream, list) ;

	print_each_elm(list);

	printf("remove 1st line:\n") ;
	[list moveToHead] ; [list remove] ;
	print_each_elm(list);

	printf("remove 3rd line:\n") ;
	[list moveNext] ; [list remove] ;
	print_each_elm(list);

	printf("remove last line:\n") ;
	[list moveToTail] ; [list remove] ;
	print_each_elm(list);

	printf("add lines:\n") ;
	str = [CConstStr newConstStr:  "additional line"] ;
	[list add: str] ;
	[str release] ;

	str = [CConstStr newConstStr:  "more additional line"] ;
	[list add: str] ;
	[str release] ;

	print_each_elm(list);

	printf("insert lines:\n") ;

	str = [CConstStr newConstStr:  "inserted line"] ;
	[list insert: str] ;
	[str release] ;

	[list moveToTail] ;

	str = [CConstStr newConstStr:  "more inserted line"] ;
	[list insert: str] ;
	[str release] ;

	print_each_elm(list);

	[list clear] ;
	print_list("cleared", stream, list) ;

	[stream flush] ;
	[stream release] ;
	[list release] ;
	printf("bye.\n");
	return 0 ;
}

