/*
 NAME
 	cidhash-test.m - test program for CIdHash class
 VERSION
 	$Id$
 CHANGELOG
 	$Log$
 */

#include <coconut/cidhash.h>
#include <coconut/cindtstream.h>
#include <coconut/cconststr.h>
#include <coconut/fobject.h>
#include <stdio.h>

void print_hash(const char * msg, id <PIndentStream> stream, id <PIdHash> hash)
{
	printf("----- %s\n", msg) ;
	printf("elm num : %d\n", [hash count]) ;
	[hash print: stream] ;
	[stream flush] ;
	printf("----- end of %s\n", msg) ;
}

void add(id <PIdHash> hash, const char * ptr)
{
	id <PConstStr>	str ;

	str = [CConstStr newConstStr: ptr] ;
	[hash add: ptr object: str] ;
	[str release] ;
}

int main()
{
	id <PIdHash>		hash ;
	id <PIndentStream>	stream ;
	id <PConstStr>		str ;
	char *			key ;

	printf("*** test program for CIdHash class\n") ;
	hash = [[CIdHash alloc] initIdHash: &g_str_hash 
	  equalKeyFunc: &g_str_equal removeKeyFunc: &remove_nothing_func] ;
	stream = [[CIndtStream alloc] init] ;

	print_hash("initial state:", stream, hash) ;

	add(hash, "1st key/value") ;
	add(hash, key = "2nd key/value") ;
	add(hash, "3rd key/value") ;
	print_hash("after 3 datas added:", stream, hash) ;

	str = [hash search: key] ;
	printf("search \"%s\" -> result \"%s\"\n", key, [str ptr]);
	fflush(stdout) ;

	[hash clear] ;
	print_hash("after cleared:", stream, hash) ;

	[stream flush] ;
	[stream release] ;
	[hash release] ;
	printf("bye.\n") ;
	return 0 ;
}

