/*****
 NAME
	cidarray-test.m - test program for CIdArray class
 VERSION
	$Id$
 CHANGELOG
	$Log$
 */

#include <coconut/cidarray.h>
#include <coconut/cindtstream.h>
#include <coconut/cint.h>
#include <coconut/fobject.h>
#include <stdio.h>
#include <stdlib.h>

void print_array(const char * msg, id <PIndentStream> stream, 
  id <PIdArray> arr)
{
	id <PNumber>	first ;
	id <PNumber>	last ;

	printf("%s -----\n", msg);
	printf("elm num : %d\n", [arr count]) ;
	fflush(stdout) ;

	[arr print: stream] ;
	[stream flush] ;

	first = [arr first] ; last = [arr last] ;

	if(first)
		printf("1st : %d\n", [first intNum]) ;
	if(last)
		printf("last : %d\n", [last intNum]) ;
	printf("end of %s -----\n", msg);
}

void appendArray(id <PIdArray> arr, int i)
{
	id <PNumber>	num ;
	num = [CInt newInt: i format: dec_format] ; 
	[arr append: num] ; [num release] ;
}

void prependArray(id <PIdArray> arr, int i)
{
	id <PNumber>	num ;
	num = [CInt newInt: i format: dec_format] ; 
	[arr prepend: num] ; [num release] ;
}

int main()
{
	id <PIdArray> 		arr ;
	id <PIndentStream>	stream ;
	int			cmpval ;
	id <PNumber>		num ;
	u_int			idx ;

	printf("*** test program for CIdArray class\n");
	arr = [[CIdArray alloc] init] ;
	stream = [[CIndtStream alloc] init] ;

	print_array("initial state", stream, arr) ;

	appendArray(arr, 0) ;
	print_array("1st data added", stream, arr) ;

	appendArray(arr, 1) ;
	print_array("2nd data added", stream, arr) ;

	appendArray(arr, 2) ;
	print_array("3rd data added", stream, arr) ;

	appendArray(arr, 3) ;
	print_array("4th data added", stream, arr) ;

	prependArray(arr, 4) ;
	prependArray(arr, 5) ;
	print_array("4th and 5th data set", stream, arr) ;
	[stream flush] ;

	num = [arr item: 1] ; printf("slot[1] = %d\n", [num intNum]) ; 
	num = [arr item: 2] ; printf("slot[2] = %d\n", [num intNum]) ; 

	cmpval = 4 ;
	if([arr search: &idx by: [CInt newInt: cmpval format: dec_format]]){
		printf("search %d -> FOUND in %d \n", cmpval, idx) ;
	} else {
		printf("search %d -> NOT FOUND, this is error.\n", cmpval) ;
	}

	[stream flush] ;
	[stream release] ;
	[arr release] ;
	printf("bye.\n") ;
	exit(0) ;
}

