/*****
 NAME
 	chtmltree-test.m - test program for CHTMLTree class
 VERSION
 	$Id$
 CHANGELOG
 	$Log$
 */

#include <coconut/chtmltree.h>

int main()
{
	id <PXMLTree>	tree ;
	id <PError>	err ;
	u_int		lineno ;

	printf("*** self test program for CHTMLTree class\n");

	tree = [[CHTMLTree alloc] init] ;
	lineno = [tree loadFile: "./chtmltree-test.html" validate: FALSE] ;
	printf("load result ... %u\n", lineno) ;
	g_assert(lineno == 0) ;

	printf("save to the standard output (1):\n") ;
	err = [tree saveStream: nil] ;
	printf("save result ... %x\n", [err code]) ;

	printf("make empty document:\n") ;
	[tree newDocument: "chtmltree-test2.html"] ;
	printf("add the root object:\n") ;
	[tree addNextNode: "html" content: ""] ;
	printf("save to the standard output (2):\n") ;
	err = [tree saveStream: nil] ;
	printf("save result ... %x\n", [err code]) ;

	[tree release] ;
	printf("bye\n") ;
	return 0 ;
}

