/*
 NAME
 	chash-test.m - test program for CHash class
 VERSION
 	$Id$
 CHANGELOG
 	$Log$
 */

#include <coconut/chash.h>
#include <coconut/cindtstream.h>
#include <coconut/fobject.h>
#include <stdio.h>

const void * printElm(const void * key, const void * data, const void * p1, 
  const void * p2)
{
	id <PIndentStream>	stream = (id <PIndentStream>) p1 ;
	[stream putFormat: "key: \"%s\", value: \"%s\"\n", key, data] ;
	return NULL ;
}

void print_hash(const char * msg, id <PIndentStream> stream, id <PDataHash> hash)
{
	printf("----- %s\n", msg) ;
	printf("elm num : %d\n", [hash count]) ;
	[hash foreachHash: &printElm with: stream with: NULL] ;
	[stream flush] ;
	printf("----- end of %s\n", msg) ;
}

int main()
{
	id <PDataHash>		hash ;
	id <PIndentStream>	stream ;
	char * 			str ;

	printf("*** test program for CHash class\n") ;
	hash = [[CHash alloc] initHash: &g_str_hash equal: &g_str_equal
	  removeKey: &remove_nothing_func removeData: &remove_memory_func] ;
	stream = [[CIndtStream alloc] init] ;

	print_hash("initial state:", stream, hash) ;

	str = strdup("1st key/value") ;
	[hash add: str data: str] ;
	str = strdup("2nd key/value") ;
	[hash add: str data: str] ;
	str = strdup("3rd key/value") ;
	[hash add: str data: str] ;
	print_hash("after 3 datas added:", stream, hash) ;

	printf("search \"%s\" -> result \"%s\"\n", str, (char *) 
	  [hash search: str]) ;

	[hash clear] ;
	print_hash("after cleared:", stream, hash) ;

	[stream flush] ;
	[stream release] ;
	[hash release] ;
	printf("bye.\n") ;
	return 0 ;
}

