/*****
 NAME
 	cguiparser-test.m - test program for CGUIParser class
 VERSION
 	$Id$
 CHANGELOG
 	$Log$
 */

#include <coconut/gtk/cguisystem.h>
#include <coconut/gtk/cguiparser.h>
#include <coconut/cxmltree.h>
#include <coconut/cfile.h>
#include <coconut/cmessage.h>
#include <coconut/cerror.h>
#include <coconut/papplication.h>

@interface CGUIParserTest : CGUISystem <PApplication>
{
}

- (void) quit ;

@end

@implementation CGUIParserTest
- (id <PError>) prologue: (int) argc argv: (const char **) argv
{
	printf("prologue\n");
	return [super prologue: argc argv:argv] ;
}

- (id <PError>) main
{
	static const char	fname[] = "cguiparser-test2.xml" ;
	id <PGUIParser> 	parser ;
	id <PXMLTree>		xmldata ;
	id <PWindow>		window ;
	id <PFile>		stream ;
	id <PError>		err ;

	printf("main\n") ;

	/* open input file */
	printf("open input file \"%s\" ... ", fname) ;
	stream = [[CFile alloc] init] ;
	err = [stream open: read_open name: fname] ;
	if(err != nil){
		[CMessage message: error_message code: [err code]
		  format: "can not read \"%s\"", fname] ;
		return err ;
	}
	printf("OK\n") ;

	/* load xml data */
	printf("loading input data ... ") ;
	xmldata = [[CXMLTree alloc] init] ;
	if([xmldata loadStream: stream name: fname validate: FALSE] != 0){
		[CMessage message: error_message code: (int)
		  illegal_format_err 
		  format: "failed to load input file \"%s\"\n", fname] ;
		return [CError illegal_format] ;
	}
	printf("OK\n") ;

	/* make window data */
	printf("make widgets ... ") ;
	parser = [[CGUIParser alloc] init] ;
	window = [parser parse: xmldata] ;
	if(window == nil){
		printf("ERROR: failed to allocate window\n") ;
		return [CError unknown] ;
	}
	printf("OK\n") ;

	/* close input file */
	[stream close] ;
	[stream release] ;

	[window doExitAfterDelete] ;
	[window show] ;
	return [super main] ;
}

- (id <PError>) epilogue: (id <PError>) preerror
{
	printf("epilogue\n");
	return no_error ;
	return [super epilogue: preerror] ;
}

- (void) quit
{
	printf("click event occured. good bye !!\n") ;
	[super exitMainLoop: nil] ; 
}

@end

int main(int argc, const char **argv){
	id system ;
	int status ;

	printf("argv[0] = %s\n", &(argv[0][0])) ;
	system = [[CGUIParserTest alloc] init] ;
	status = start_program(system, argc, argv) ;
	printf("bye (code %d, %s)\n", status, [CSystem applicationName]) ;
	[system release] ;
	return status ;
}

