/*****
 NAME
 	cframe-test.m
 VERSION
 	$Id$
 CHANGELOG
 	$Log$
 */

#include <coconut/gtk/cguisystem.h>
#include <coconut/gtk/cframe.h>
#include <coconut/gtk/clabel.h>
#include <coconut/gtk/cwindow.h>
#include <coconut/papplication.h>

@interface CFrameTest : CGUISystem <PApplication>
{
	CWindow *	window ;
	CFrame *	frame ;
	CLabel *	label ;
}

@end

@implementation CFrameTest
- (id <PError>) prologue: (int) argc argv: (const char **) argv
{
	printf("prologue\n");
	return [super prologue: argc argv:argv] ;
}

- (id <PError>) main
{
	printf("main\n") ;

	printf("initialize window\n") ;
	window = [[CWindow alloc] initWindow: window_toplevel align: 
	  screen_align_center] ;

	printf("initialize frame\n") ;
	frame = [[CFrame alloc] initFrame: "Message from Author"] ;

	printf("initialize label\n") ;
	label = [[CLabel alloc] initLabel: "Hello, World!!"] ;

	printf("add label to frame\n") ;
	[frame appendWidget: label] ;

	printf("add frame to window\n") ;
	[window appendWidget: frame] ;

	printf("showing window at the center of screen\n"
	  "*** If you see the \"hello world\" message window,\n"
	  "*** please close the window. And if you not see the message,\n"
	  "*** it's error. press \"C\" key with Control key\n") ;
	[window doExitAfterDelete] ;
	[window show] ;
	printf("main routine.\n") ;
	return [super main] ;
}

- (id <PError>) epilogue: (id <PError>) preerror
{
	printf("epilogue\n");
	return [super epilogue: preerror] ;
}

@end

int main(int argc, const char **argv){
	id system ;
	int status ;

	printf("argv[0] = %s\n", &(argv[0][0])) ;
	system = [[CFrameTest alloc] init] ;
	status = start_program(system, argc, argv) ;
	[system release] ;
	printf("bye (code %d, %s)\n", status, [CSystem applicationName]) ;
	return status ;
}

