/*****
 NAME
 	cfile-test.m - test program for CFile class
 VERSION
 	$Id$
 CHANGELOG	
 	$Log$
 */

#include <coconut/cfile.h>
#include <unistd.h>

void print_code(const char *msg, id <PError> err)
{
	printf("%s -> error code %d\n", msg, (int) [err code]) ;
}

void print_status(const char *msg, io_status_t stat)
{
	printf("%s -> io status %d\n", msg, (int) stat) ;
}

void testIsLegalName(const char * name)
{
	printf("file name: \"%s\" is %s.\n", name ? name : "NULL",
	  [CFile isLegalName: name] ? "legal" : "illegal") ;
}

void testIsExist(const char * name)
{
	printf("the file \"%s\" is%s exist\n", name, [CFile isFileExist: name] ?
	  "" : " NOT") ;
}

void testFileName(const char * name)
{
	id <PConstStr>	str ;

	printf("name : \"%s\"\n", name) ;
	printf(" isAbsolutePath: %d\n", [CFile isAbsolutePath: name]) ;

	str = [CFile getBaseName: name] ;
	printf(" base name: %s\n", [str ptr]) ;
	[str release] ;

	str = [CFile getDirName: name] ;
	printf(" dir name:  %s\n", [str ptr]) ;
	[str release] ;
}

void testDirect(void)
{
	GIOChannel *		channel ;
	GIOStatus		stat ;
	gsize			ressize ;

	printf("--- direct function test\n");
	channel = g_io_channel_unix_new(STDOUT_FILENO) ;
	g_assert(channel != NULL) ;
	g_io_channel_set_close_on_unref(channel, FALSE) ;
	stat = g_io_channel_write_chars(channel, "hello\n", -1, &ressize, NULL);
	printf("status : %d\n", stat) ;
	g_io_channel_flush(channel, NULL) ;
	g_io_channel_unref(channel) ;
	printf("--- end of direct function test\n");
}

int main()
{
	id <PFile>	tstfile0 ;
	id <PFile>	tstfile1 ;
	id <PFile>	tstfile2 ;
	id <PFile>	outfile ;
	id <PConstStr>	line ;
	id <PError>	err ;
	int		i ;
	char		c ;
	io_status_t	stat ;

	printf("*** test program for CFile class\n") ;

	/* factory methods */
	testIsLegalName(NULL) ;
	testIsLegalName("a/b") ;
	testIsLegalName("c") ;

	testIsExist("./cfile-test.m") ;
	testIsExist("hogehoge") ;

	testFileName("/tmp/a") ;
	testFileName("dir10/a") ;
	testFileName("") ;

	testDirect() ;

	printf("open the standard output\n") ;
	tstfile0 = [CFile newFile: write_open name: NULL] ;
	g_assert(tstfile0 != nil) ;
	stat = [tstfile0 putPtr: "this is a test file0\n"] ;
	[tstfile0 flush] ;
	printf("status : %d\n", stat) ;
	[tstfile0 close] ;
	[tstfile0 release] ;

	printf("open \"cfile-test.file1\"\n") ; ;
	tstfile1 = [CFile newFile: write_open name: "cfile-test.file1"] ;
	g_assert(tstfile1 != nil) ;

	printf("putting the message\n") ;
	stat = [tstfile1 putPtr: "this is a test file1\n"] ;
	g_assert(stat == io_status_normal) ;

	printf("closing the file\n");
	err = [tstfile1 close] ;
	g_assert(err == nil) ;

	printf("releasing the file\n");
	[tstfile1 release] ;

	/* make test file */
	printf("make file output file 2\n") ;
	tstfile2 = [[CFile alloc] init] ;
	g_assert(tstfile2 != nil) ;

	print_code("open", [tstfile2 open: write_open name:"cfile-test.file2"]);
	print_status("put", [tstfile2 putPtr: "this is test file generated by"
	  " 'cfile-test.out'\n"]) ;
	printf("putPtr (1)\n") ;
	[tstfile2 putPtr: "next line containes 1234 characters\n"] ;
	printf("putPtr (loop)\n") ;
	for(i = 0 ; i<1234 ; i++){ 
		c = 'a' + i % 26 ;
		stat = [tstfile2 putChar: c] ;
		if(stat != io_status_normal){	
			printf("ERROR: code %x\n", (int) stat) ;
		}
	}
	print_status("putChar", [tstfile2 putChar: '\n']) ;
	printf("putPtr (2)\n") ;
	print_status("putPtr (1)", [tstfile2 putPtr: "next line is a last "
	  "line without NEWLINE code.\n"]) ;
	print_status("putPtr (3)", [tstfile2 putPtr: "this is a last line\n"]) ;
	print_status("putFormat (1)", [tstfile2 putFormat: "this is formated "
	  "line: %c, %d, %s\n", 'a', 10, "bcd"]) ;
	printf("tst file name: \"%s\"\n", [[tstfile2 fileName] ptr]) ;

	printf("closing the file 2\n");
	err = [tstfile2 close] ;
	g_assert(err == nil) ;

	/* read the file */
	printf("prepating output file\n") ;
	outfile = [[CFile alloc] init] ;
	print_code("r-open",[tstfile2 open: read_open name:"cfile-test.file2"]);
	print_code("w-open",[outfile open: write_open name:"cfile-test.res"]);
	while((line = [tstfile2 getLine]) != nil){
		printf("(size %d) %s", [line size], [line ptr]) ;
		print_status("write", [outfile putStr: line]) ;
		[line release] ;
	}
	printf("output file name: \"%s\"\n", [[outfile fileName] ptr]) ;

	print_code("w-close", [outfile close]) ;
	print_code("r-close", [tstfile2 close]) ;

	printf("bye.\n") ;
	return 0 ;
}

