/*****
 NAME
 	cexpvar-test.m - test program for CExpVar class
 VERSION
 	$Id$
 CHANGELOG
 	$Log$
 */

#include <coconut/cexpvar.h>
#include <coconut/cindtstream.h>
#include <coconut/cconststr.h>
#include <coconut/cint.h>
#include <stdlib.h>

int main()
{
	id <PExpVar>		var1 ;
	id <PIndentStream>	stream ;
	id <PConstStr>		name ;
	id <PNumber>		num ;

	printf("*** test program for CExpVar class\n") ;
	stream = [[CIndtStream alloc] init] ;

	var1 = [[CExpVar alloc] init] ;
	[stream putPtr: "initial state:\n"] ;
	[var1 print: stream] ;
	[stream putChar: '\n'] ;

	[stream putPtr: "set integer 100:\n"] ;
	name = [[CConstStr alloc] initConstStr: "expvar1"] ;
	num = [[CInt alloc] init] ;
	[num setInt: 100] ;
	[var1 setName: name] ;
	[var1 setValue: num] ;
	[var1 print: stream] ;
	[stream putChar: '\n'] ;

	[stream putFormat: "hash value is not 0: %s\n", 
	  ([var1 hashkey] > 0 ? "yes" : "no")] ;
	[stream putFormat: "compare result %d\n", [var1 compare: var1]] ;

	[stream putPtr: "end of stream\n"] ;
	[stream flush] ;
	
	[stream release] ;
	[var1 release] ;
	printf("bye\n") ;
	exit(0) ;
}

