/*
 NAME
 	cexpconst-test.m - test program for CExpConst class
 VERSION
 	$Id$
 CHANGELOG
 	$Log$
 */

#include <coconut/cexpconst.h>
#include <coconut/creal.h>

static void printNum(id <PNumber> num)
{
	id <PString>	str ;

	str = [num toString] ;
	printf("type %x, value %f, str \"%s\"\n", [num type], [num realNum],
	  [str ptr]) ;
	[str release] ;
}

static void printExp(id <PExp> exp)
{
	id <PString>	str ;
	str = [exp toString] ;
	printf("status %x, value %s\n", [exp status], [str ptr]) ;
	[str release] ;
}

int main()
{
	id <PExpConst>	exp1 ;
	id <PExpConst>	exp2;
	id <PNumber>	real1 ;

	printf("*** test program for CExpConst class\n") ;
	real1 = [CReal newReal: 3.14] ;
	exp1 = [[CExpConst alloc] initExpConst: real1] ;
	exp2 = [[CExpConst alloc] init] ;

	printf("value:\n") ;
	printNum([exp1 eval]) ;

	printf("toString:\n") ;
	printExp(exp1) ;
	printExp(exp2) ;

	[real1 release] ;
	[exp1 release] ;
	printf("bye.\n");
	return 0 ;
}

