/*****
 NAME
 	cdir-test.m - test program for CDir class
 VERSION
 	$Id$
 CHANGELOG
 	$Log$
 */

#include <coconut/cdir.h>
#include <coconut/cconststr.h>
#include <coconut/cindtstream.h>
#include <stdlib.h>

void printDir(const char * name, boolean result)
{
	printf("the directory \"%s\" is", name) ;
	if(!result)
		printf(" NOT") ;
	printf(" exist.\n") ;
}

int main()
{
	id <PDir>		dir ;
	id <PConstStr>		name ;
	id <PConstStr>		result ;
	id <PIndentStream>	stream ;

	const char 	dir1[] = "OK" ;
	const char 	dir2[] = "../coconut" ;
	const char 	dir3[] = "./hoge" ;

	printf("*** test program for CDir class\n") ;
	stream = [[CIndtStream alloc] init] ;

	printf("--- append dirs to the list\n") ;
	dir = [[CDir alloc] init] ;
	name = [[CConstStr alloc] initConstStr: dir1] ;
	printDir(dir1, [dir appendPath: name]) ;
	[name release] ;

	name = [[CConstStr alloc] initConstStr: dir2] ;
	printDir(dir2, [dir appendPath: name]) ;
	[name release] ;

	name = [[CConstStr alloc] initConstStr: dir3] ;
	printDir(dir3, [dir appendPath: name]) ;
	[name release] ;

	printf("--- the number of pathes\n");
	printf(" %d\n", [dir count]) ;

	printf("--- print the contents\n") ;
	fflush(stdout) ;
	[dir print: stream] ;
	[stream flush] ;

	printf("--- search file in the list\n") ;
	result = [dir searchFile: "cdir.m"] ;
	printf("search result : \"%s\"\n", result ? (char *) [result ptr] : 
	  (char *) "<none>") ;

	[dir release] ;
	[stream release] ;
	printf("bye\n") ;
	exit(0) ;
}

