/*****
 NAME
 	ccontainer-test.m
 VERSION
 	$Id$
 CHANGELOG
 	$Log$
 */

#include <coconut/gtk/cguisystem.h>
#include <coconut/gtk/cwindow.h>
#include <coconut/gtk/ccontainer.h>
#include <coconut/gtk/clabel.h>
#include <coconut/gtk/cbutton.h>
#include <coconut/papplication.h>

@interface CContainerTest : CGUISystem <PApplication>
{
	CWindow *	window ;
}

@end

@implementation CContainerTest
- (id <PError>) prologue: (int) argc argv: (const char **) argv
{
	printf("prologue\n");
	return [super prologue: argc argv:argv] ;
}

- (id <PError>) main
{
	id <PContainer>	container ;
	id <PLabel>	label ;
	id <PButton>	button ;

	printf("main\n") ;

	printf("initialize window\n") ;
	window = [[CWindow alloc] initWindow: window_toplevel align: 
	  screen_align_center] ;

	printf("initialize container\n") ;
	container = [[CContainer alloc] initContainer: TRUE homogeneous: TRUE 
	  spacing: 10] ;

	printf("add container to window\n") ;
	[window appendWidget: container] ;

	printf("initialize label\n") ;
	label = [[CLabel alloc] initLabel: "label"] ;

	printf("add label to container\n") ;
	[container appendWidget: label] ;

	printf("initialize button\n") ;
	button = [[CButton alloc] initButton: "button"] ;

	printf("add label to container\n") ;
	[container appendWidget: button] ;

	printf("showing window at the center of screen\n"
	  "you will see the window contains label and button.\n") ;
	[window doExitAfterDelete] ;
	[window show] ;
	printf("main routine.\n") ;
	return [super main] ;
}

- (id <PError>) epilogue: (id <PError>) preerror
{
	printf("epilogue\n");
	return [super epilogue: preerror] ;
}

@end

int main(int argc, const char **argv){
	id system ;
	int status ;

	printf("argv[0] = %s\n", &(argv[0][0])) ;
	system = [[CContainerTest alloc] init] ;
	status = start_program(system, argc, argv) ;
	[system release] ;
	printf("bye (code %d, %s)\n", status, [CSystem applicationName]) ;
	return status ;
}

