/*****
 NAME
	cconststr-test.m - test program for CMemory class
 VERSION
	$Id$
 CHANGELOG
	$Log$
 */

#include <coconut/cconststr.h>
#include <coconut/cindtstream.h>
#include <stdio.h>
#include <stdlib.h>

@interface CTestStr : CConstStr <PConstStr>
{
}

- initTestStr: (const utf8_char *) str copy: (boolean) c free: (boolean) f ;

@end

@implementation CTestStr

- init 
{
	printf("init without parameters\n");
	return [super init] ;
}

- initTestStr: (const utf8_char *) str copy: (boolean) doc free: (boolean) dof
{
	printf("str=\"%s\", docopy=%d dofree=%d \n", str, doc, dof);
	return [super initConstStr: str copy:doc free: dof] ;
}

- (void) dealloc
{
	printf("dealloc\n") ;
	[super dealloc] ;
}

- (const utf8_char *) setStr: (id <PBasicStr>) str ;
{
	const utf8_char * result ;
	result = [super setStr: str] ;
	printf("setStr: \"%s\"\n", result) ;
	return result ;
}

- (const utf8_char *) setPtr: (const utf8_char *) str
{
	const utf8_char * result ;
	result = [super setPtr: str] ;
	printf("setPtr: \"%s\"\n", result) ;
	return result ;
}

- (const utf8_char *) setPtr: (const utf8_char *) str length: (u_int) len
{
	const utf8_char * result ;
	result = [super setPtr: str length: len] ;
	printf("setPtr: \"%s\" (length %u) \n", result, len) ;
	return result ;
}

- (const utf8_char *) setPtr: (const utf8_char *) str copy: (boolean) docopy
    free: (boolean) dofree
{
	printf("setPtr: %s copy: %d free: %d\n", str, docopy, dofree) ;
	return [super setPtr: str copy: docopy free: dofree] ;
}

- (const utf8_char *) ptr
{
	const char * str = [super ptr] ;
	/* printf("ptr : \"%s\"\n", str ? str : "<null>") ; */
	return str ;
}

- (boolean) isEmpty
{
	boolean	result ;
	result = [super isEmpty] ;
	printf("is empty : %d", (int) result) ;
	return result ;
}

- (size_t) length
{
	size_t len = [super length] ;
	printf("length : %d\n", len) ;
	return len ;
}

- (size_t) size
{
	size_t size = [super size] ;
	printf("size : %d\n", size) ;
	return size ;
}

- (int) compare: (id <PBasicStr>) str
{
	return [super compare: str] ;
}

- (int) comparePtr: (const utf8_char *) str length: (u_int) len
{
	int	result ;

	result = [super comparePtr: str length: len] ;
	printf("comparing w case \"%s\" (%d) and \"%s\" (%d) => %d\n",
	  [self ptr], [self length], str, len, result) ;
	return result ;
}

- (int) comparePtr: (const utf8_char *) str 
{
	int	result ;

	result = [super comparePtr: str] ;
	if(result > 0)
		result = 1 ;
	else if(result < 0)
		result = -1 ;
	printf("comparing w/o case \"%s\" and \"%s\" => %d\n",
	  [self ptr], str, result) ;
	return result ;
}

- (int) comparePtrWoCase: (const utf8_char *) str length: (u_int) len
{
	int	result ;

	result = [super comparePtrWoCase: str length: len] ;
	printf("comparing w/o case \"%s\" (%d) and \"%s\" (%d) => %d\n",
	  [self ptr], [self length], str, len, result) ;
	return result ;
}

- (int) comparePtrWoCase: (const utf8_char *) str 
{
	int	result ;

	result = [super comparePtrWoCase: str] ;
	printf("comparing w/o case \"%s\" and \"%s\" => %d\n",
	  [self ptr], str, result) ;
	return result ;
}

- (id <PConstStr>) duplicate
{
	printf("duplicate\n") ;
	return [super duplicate] ;
}

- print: (id) dummy
{
	id <PIndentStream>	stream ;

	stream = [[CIndtStream alloc] init] ;
	  [super print: stream] ;
	  [stream putChar: '\n'] ;
	[stream release]; 
	return nil ;
}

- (u_int) hashkey
{
	u_int	hashkey ;
	hashkey = [super hashkey] ;
	printf("hash key value: %u\n", hashkey) ;
	return hashkey ;
}

@end

void print_info(id <PConstStr> obj)
{
	[obj ptr] ;
	[obj length] ;
	[obj size] ;
}

int main()
{
	id <PConstStr>	obj1, obj2, obj3, obj4 ;
	utf8_char *	str ;
	int		len ;

	printf("*** test program for CConstStr class\n");
	obj1 = [[CTestStr alloc] init] ;
	obj2 = [[CTestStr alloc] initTestStr: "Hello" copy:TRUE free: TRUE] ;

	str = strdup("duplicated string") ;
	obj3 = [[CTestStr alloc] initTestStr: str copy:FALSE free: TRUE] ;

	print_info(obj1) ;
	print_info(obj2) ;
	print_info(obj3) ;

	[obj1 setPtr: "reseted string"] ;
	print_info(obj1) ;

	[obj1 setPtr: "hello,world" length: 5] ;
	print_info(obj1) ;

	printf("more duplicated string\n") ;
	obj4 = [obj1 duplicate] ;
	print_info(obj4) ;
	[obj4 release] ;

	printf("compare function\n") ;
	[obj1 setPtr: "Hello, World" copy: FALSE free: FALSE] ;
	len = strlen("Hello") ;

	[obj1 comparePtr: "HELLO, EVERYBODY"] ;
	[obj1 comparePtr: "HELLO, EVERYBODY" length: len] ;
	[obj1 comparePtrWoCase: "HELLO, EVERYBODY"] ;
	[obj1 comparePtrWoCase: "HELLO, EVERYBODY" length: len] ;

	printf("hash key\n") ;
	[obj1 hashkey] ;
	[obj2 hashkey] ;
	[obj3 hashkey] ;

	printf("print stream\n") ;
	fflush(stdout) ;
	[obj1 print: nil] ;

	[obj1 release] ;
	[obj2 release] ;
	[obj3 release] ;
	printf("bye.\n") ;
	return 0 ;
}

