/*
 NAME
 	ccmdparser-test1.m - test program for CCmdParser class
 VERSION
 	$Id$
 CHANGELOG
 	$Log$
 */

#include <coconut/ccmdparser.h>
#include <coconut/cxmltree.h>

int main()
{
	id <PCmdParser>		parser ;
	id <PXMLTree>		tree ;
	id <PTree>		cmdtree ;
	id <PError>		result ;
	u_int			lineno ;

	printf("*** test program for CCmdParser (1)\n") ;
	printf("load the xml data:\n") ;
	fflush(stdout) ;

	tree = [[CXMLTree alloc] init] ;
	lineno = [tree loadFile: "ccmdparser-test1.xml" validate: FALSE] ;
	if(lineno != 0){
		printf("illegal format at line %u\n", lineno) ;
		exit(1) ;
	}

	printf("allocate the parser:\n") ;
	parser = [[CCmdParser alloc] init] ;
	printf("set verbose mode:\n") ;
	[parser setVerboseMode: TRUE] ;

	printf("parse the data:\n") ;
	cmdtree = [parser parse: tree] ;

	printf("exec it:\n") ;
	result = [(id <PCommand>) [cmdtree rootNode] exec: nil with: nil] ;
	if(result){
		printf("result -> code %x\n", [result code]) ;
	} else
		printf("result -> no error\n") ;

	printf("release all objects:\n") ;
	[parser release] ; 
	[tree release] ;
	printf("bye\n") ;
	exit(0) ;
}

