/*****
 NAME
 	ccmdenv-test.m - test program for CCmdEnv class
 VERSION
 	$Id$
 CHANGELOG
	$Log$
 */

#include <coconut/ccmdenv.h>
#include <coconut/cindtstream.h>

int main()
{
	id <PIndentStream>	stream ;
	id <PCmdEnv>		cmd ;
	const char		name[] = "COCONUT_ENV" ;
	const char		name2[] = "COCONUT_OTHER" ;
	const char		value[] = "hello" ;
	const char *		valp ;

	printf("***** test program for CCmdEnv class\n") ;
	stream = [[CIndtStream alloc] init] ;

	printf("allocate cmdenv object:\n") ;
	cmd = [[CCmdEnv alloc] init] ;

	printf("set envval \"%s\" to \"%s\":\n", name, value) ;
	[cmd setNameAndValue: name value: value] ;

	printf("read the env var \"%s\" ==> \"%s\"\n", [cmd name], [cmd value]);

	printf("set another name \"%s\":\n", name2) ;
	[cmd setName: name2] ;
	valp = [cmd value] ;
	printf("read the env var \"%s\" ==> \"%s\"\n", [cmd name], 
	  valp ? valp : "<not defined>") ;

	printf("release the object:\n");
	[cmd release] ;

	printf("bye\n") ;
	return 0 ;
}

