/*****
 NAME
 	ccheckbutton-test.m - test program for CCheckButton class
 VERSION
 	$Id$
 CHANGELOG
 	$Log$
 */

#include <coconut/gtk/cguisystem.h>
#include <coconut/gtk/ccontainer.h>
#include <coconut/gtk/ccheckbutton.h>
#include <coconut/gtk/cwindow.h>
#include <coconut/papplication.h>

@interface CCheckButtonTest : CGUISystem <PApplication>
{
	CWindow *	window ;
	CContainer *	container ;
	CCheckButton *	checkbutton1 ;
	CCheckButton *	checkbutton2 ;
	CCheckButton *	checkbutton3 ;
	CCheckButton *	checkbutton4 ;
}

- (void) quit ;

@end

@implementation CCheckButtonTest
- (id <PError>) prologue: (int) argc argv: (const char **) argv
{
	printf("prologue\n");
	return [super prologue: argc argv:argv] ;
}

- (id <PError>) main
{
	printf("main\n") ;

	printf("initialize window\n") ;
	window = [[CWindow alloc] initWindow: window_toplevel align: 
	  screen_align_center] ;

	printf("initialize container\n") ;
	container = [[CContainer alloc] initContainer: TRUE
	  homogeneous: TRUE spacing: 2] ;

	printf("initialize checkbutton\n") ;
	checkbutton1 = [[CCheckButton alloc] initCheckButton: "Check Me (1)"] ;
	checkbutton2 = [[CCheckButton alloc] initCheckButton: "Check Me (2)"] ;
	[checkbutton2 toggle: TRUE] ;
	checkbutton3 = [[CCheckButton alloc] initCheckButton: "Check Me (3)"] ;
	[checkbutton3 setInconsistent: TRUE] ;
	checkbutton4 = [[CCheckButton alloc] initCheckButton: "Check Me (4)"] ;
	[checkbutton4 setIndicator: TRUE] ;

/*
	printf("connect checkbutton to quit event\n");
	[checkbutton connectClickedEvent: self message:@selector(quit)
	  with: NULL] ;
 */
	printf("add checkbutton to container\n") ;
	[container appendWidget: checkbutton1] ;
	[container appendWidget: checkbutton2] ;
	[container appendWidget: checkbutton3] ;
	[container appendWidget: checkbutton4] ;

	printf("add container to window\n") ;
	[window appendWidget: container] ;

	printf("showing window at the center of screen\n"
	  "*** If you see the \"Check Me\" checkbutton,\n"
	  "*** please click it or close window. If you not see the checkbutton,\n"
	  "*** it's error. press \"C\" key with Control key\n") ;
	[window doExitAfterDelete] ;
	[window show] ;

	return [super main] ;
}

- (id <PError>) epilogue: (id <PError>) preerror
{
	printf("epilogue\n");
	return [super epilogue: preerror] ;
}

- (void) quit
{
	printf("click event occured. good bye !!\n") ;
	[super exitMainLoop: nil] ; 
}

@end

int main(int argc, const char **argv){
	id system ;
	int status ;

	printf("argv[0] = %s\n", &(argv[0][0])) ;
	system = [[CCheckButtonTest alloc] init] ;
	status = start_program(system, argc, argv) ;
	[system release] ;
	printf("bye (code %d, %s)\n", status, [CSystem applicationName]) ;
	return status ;
}

