/*
 NAME
 	cbuttom-test.m - test program for CButton class
 VERSION
 	$Id$
 CHANGELOG
 	$Log$
 */

#include <coconut/gtk/cguisystem.h>
#include <coconut/gtk/cbutton.h>
#include <coconut/gtk/cwindow.h>
#include <coconut/papplication.h>

@interface CButtonTest : CGUISystem <PApplication>
{
	CWindow *	window ;
	CButton *	button ;
}

- (void) quit ;

@end

@implementation CButtonTest
- (id <PError>) prologue: (int) argc argv: (const char **) argv
{
	printf("prologue\n");
	return [super prologue: argc argv:argv] ;
}

- (id <PError>) main
{
	printf("main\n") ;

	printf("initialize window\n") ;
	window = [[CWindow alloc] initWindow: window_toplevel align: 
	  screen_align_center] ;

	printf("initialize button\n") ;
	button = [[CButton alloc] initButton: "Click Me"] ;

	printf("connect button to quit event\n");
	[button connectClickedEvent: self message:@selector(quit)
	  with: NULL] ;

	printf("add button to window\n") ;
	[window appendWidget: button] ;

	printf("showing window at the center of screen\n"
	  "*** If you see the \"click me\" button,\n"
	  "*** please click it or close window. If you not see the button,\n"
	  "*** it's error. press \"C\" key with Control key\n") ;
	[window doExitAfterDelete] ;
	[window show] ;

	return [super main] ;
}

- (id <PError>) epilogue: (id <PError>) preerror
{
	printf("epilogue\n");
	return [super epilogue: preerror] ;
}

- (void) quit
{
	printf("click event occured. good bye !!\n") ;
	[super exitMainLoop: nil] ; 
}

@end

int main(int argc, const char **argv){
	id system ;
	int status ;

	printf("argv[0] = %s\n", &(argv[0][0])) ;
	system = [[CButtonTest alloc] init] ;
	status = start_program(system, argc, argv) ;
	[system release] ;
	printf("bye (code %d, %s)\n", status, [CSystem applicationName]) ;
	return status ;
}

