/*****
 NAME
	cboolean-test.m 
 VERSION
	$Id$
 CHANGELOG
	$Log$
 */

#include <coconut/cboolean.h>
#include <stdlib.h>

void print_boolean(id <PNumber> obj1, id <PNumber> obj2)
{
	const char * obj1str = [CBoolean booleanToStr: [obj1 booleanNum]] ;
	const char * obj2str = [CBoolean booleanToStr: [obj2 booleanNum]] ;
	printf("obj1 = %s, obj2 = %s\n", obj1str, obj2str) ;
}

int main()
{
	id <PError>	err ;
	const char	str1[] = "true" ;
	const char	str2[] = "FALSE" ;
	boolean		val ;
	id <PNumber>	obj1 ;
	id <PNumber>	obj2 ;

	printf("*** test program for CBoolean class\n") ;
	obj1 = [[CBoolean alloc] init] ;
	obj2 = [[CBoolean alloc] init] ;
	printf("initial state:\n") ;
	print_boolean(obj1, obj2) ;

	printf("set methods:\n") ;
	[obj1 setBoolean: TRUE] ;
	[obj2 setInt: 2] ;
	print_boolean(obj1, obj2) ;

	printf("convert functions:\n");
	err = [CBoolean strToBoolean: str1 to: &val] ;
	printf("convert: \"%s\" -> %d (code %x)\n", str1, val, [err code]) ;
	err = [CBoolean strToBoolean: str2 to: &val] ;
	printf("convert: \"%s\" -> %d (code %x)\n", str2, val, [err code]) ;

	[obj1 release] ; [obj2 release] ;
	printf("bye.\n") ;
	return 0 ;
}

